/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HttpOutputTest {
    private Server _server;
    private LocalConnector _connector;
    private ContentHandler _handler;

    @Before
    public void init() throws Exception {
        this._server = new Server();
        HttpConnectionFactory http = new HttpConnectionFactory();
        http.getHttpConfiguration().setRequestHeaderSize(1024);
        http.getHttpConfiguration().setResponseHeaderSize(1024);
        http.getHttpConfiguration().setOutputBufferSize(4096);
        this._connector = new LocalConnector(this._server, (ConnectionFactory)http, null);
        this._server.addConnector((Connector)this._connector);
        this._handler = new ContentHandler();
        this._server.setHandler((Handler)this._handler);
        this._server.start();
    }

    @After
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testSimple() throws Exception {
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
    }

    @Test
    public void testSendArray() throws Exception {
        int i;
        byte[] buffer = new byte[16384];
        Arrays.fill(buffer, 0, 4096, (byte)-103);
        Arrays.fill(buffer, 4096, 12288, (byte)88);
        Arrays.fill(buffer, 12288, 16384, (byte)102);
        this._handler._content = ByteBuffer.wrap(buffer);
        this._handler._content.limit(12288);
        this._handler._content.position(4096);
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\r\nXXXXXXXXXXXXXXXXXXXXXXXXXXX"));
        for (i = 0; i < 4096; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)-103L, (long)buffer[i]);
        }
        for (i = 12288; i < 16384; ++i) {
            Assert.assertEquals((String)("i=" + i), (long)102L, (long)buffer[i]);
        }
    }

    @Test
    public void testSendInputStreamSimple() throws Exception {
        Resource simple = Resource.newClassPathResource((String)"simple/simple.txt");
        this._handler._contentInputStream = simple.getInputStream();
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 11"));
    }

    @Test
    public void testSendInputStreamBig() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._contentInputStream = big.getInputStream();
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
    }

    @Test
    public void testSendInputStreamBigChunked() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._contentInputStream = new FilterInputStream(big.getInputStream()){

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int filled = super.read(b, off, len > 2000 ? 2000 : len);
                return filled;
            }
        };
        String response = this._connector.getResponses("GET / HTTP/1.1\nHost: localhost:80\n\nGET / HTTP/1.1\nHost: localhost:80\nConnection: close\n\n");
        response = response.substring(0, response.lastIndexOf("HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Transfer-Encoding: chunked"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\r\n0\r\n"));
    }

    @Test
    public void testSendChannelSimple() throws Exception {
        Resource simple = Resource.newClassPathResource((String)"simple/simple.txt");
        this._handler._contentChannel = simple.getReadableByteChannel();
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 11"));
    }

    @Test
    public void testSendChannelBig() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._contentChannel = big.getReadableByteChannel();
        String response = this._connector.getResponses("GET / HTTP/1.0\nHost: localhost:80\n\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
    }

    @Test
    public void testSendChannelBigChunked() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        final ReadableByteChannel channel = big.getReadableByteChannel();
        this._handler._contentChannel = new ReadableByteChannel(){

            @Override
            public boolean isOpen() {
                return channel.isOpen();
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                int filled = 0;
                if (dst.position() == 0 && dst.limit() > 2000) {
                    int limit = dst.limit();
                    dst.limit(2000);
                    filled = channel.read(dst);
                    dst.limit(limit);
                } else {
                    filled = channel.read(dst);
                }
                return filled;
            }
        };
        String response = this._connector.getResponses("GET / HTTP/1.1\nHost: localhost:80\n\nGET / HTTP/1.1\nHost: localhost:80\nConnection: close\n\n");
        response = response.substring(0, response.lastIndexOf("HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Transfer-Encoding: chunked"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\r\n0\r\n"));
    }

    static class ContentHandler
    extends AbstractHandler {
        InputStream _contentInputStream;
        ReadableByteChannel _contentChannel;
        ByteBuffer _content;

        ContentHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setContentType("text/plain");
            HttpOutput out = (HttpOutput)response.getOutputStream();
            if (this._content != null) {
                response.setContentLength(this._content.remaining());
                if (this._content.hasArray()) {
                    out.write(this._content.array(), this._content.arrayOffset() + this._content.position(), this._content.remaining());
                } else {
                    out.sendContent(this._content);
                }
                this._content = null;
                return;
            }
            if (this._contentInputStream != null) {
                out.sendContent(this._contentInputStream);
                this._contentInputStream = null;
                return;
            }
            if (this._contentChannel != null) {
                out.sendContent(this._contentChannel);
                this._contentChannel = null;
                return;
            }
        }
    }
}

