/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.Socket;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.junit.Assert;
import org.junit.Test;

public class HalfCloseRaceTest {
    @Test
    public void testHalfCloseRace() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        connector.setIdleTimeout(500L);
        server.addConnector((Connector)connector);
        TestHandler handler = new TestHandler();
        server.setHandler((Handler)handler);
        server.start();
        Socket client = new Socket("localhost", connector.getLocalPort());
        int in = client.getInputStream().read();
        Assert.assertEquals((long)-1L, (long)in);
        client.getOutputStream().write("GET / HTTP/1.0\r\n\r\n".getBytes());
        Thread.sleep(200L);
        Assert.assertEquals((long)0L, (long)handler.getHandled());
    }

    public static class TestHandler
    extends AbstractHandler {
        transient int handled;

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            ++this.handled;
            response.setContentType("text/html;charset=utf-8");
            response.setStatus(200);
            response.getWriter().println("<h1>Test</h1>");
        }

        public int getHandled() {
            return this.handled;
        }
    }
}

