/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GracefulStopTest {
    private Server server;

    @Before
    public void setup() throws Exception {
        this.server = new Server(0);
        StatisticsHandler stats = new StatisticsHandler();
        TestHandler test = new TestHandler();
        this.server.setHandler((Handler)stats);
        stats.setHandler((Handler)test);
        this.server.setStopTimeout(10000L);
        this.server.start();
    }

    @Test
    public void testGraceful() throws Exception {
        new Thread(){

            @Override
            public void run() {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                    GracefulStopTest.this.server.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
        try (Socket socket = new Socket("localhost", ((NetworkConnector)this.server.getBean(NetworkConnector.class)).getLocalPort());){
            socket.getOutputStream().write("GET / HTTP/1.0\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
            String out = IO.toString((InputStream)socket.getInputStream());
            Assert.assertThat((Object)out, (Matcher)Matchers.containsString((String)"200 OK"));
        }
    }

    private static class TestHandler
    extends AbstractHandler {
        private TestHandler() {
        }

        public void handle(String s, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            httpServletResponse.getWriter().write("OK");
            httpServletResponse.setStatus(200);
            request.setHandled(true);
        }
    }
}

