/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.AbstractHttpTest;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.annotation.Slow;
import org.eclipse.jetty.toolchain.test.http.SimpleHttpResponse;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.Assert;
import org.junit.Test;

public class ConnectionOpenCloseTest
extends AbstractHttpTest {
    public ConnectionOpenCloseTest() {
        super(HttpVersion.HTTP_1_1.asString());
    }

    @Slow
    @Test
    public void testOpenClose() throws Exception {
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
            }
        });
        server.start();
        final AtomicInteger callbacks = new AtomicInteger();
        final CountDownLatch openLatch = new CountDownLatch(1);
        final CountDownLatch closeLatch = new CountDownLatch(1);
        connector.addBean((Object)new Connection.Listener.Empty(){

            public void onOpened(Connection connection) {
                callbacks.incrementAndGet();
                openLatch.countDown();
            }

            public void onClosed(Connection connection) {
                callbacks.incrementAndGet();
                closeLatch.countDown();
            }
        });
        Socket socket = new Socket("localhost", connector.getLocalPort());
        socket.setSoTimeout((int)connector.getIdleTimeout());
        OutputStream output = socket.getOutputStream();
        output.write(("GET / HTTP/1.1\r\nHost: localhost:" + connector.getLocalPort() + "\r\n" + "Connection: close\r\n" + "\r\n").getBytes(StandardCharsets.UTF_8));
        output.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        SimpleHttpResponse response = this.httpParser.readResponse(reader);
        Assert.assertEquals((Object)"200", (Object)response.getCode());
        Assert.assertEquals((long)-1L, (long)reader.read());
        socket.close();
        Assert.assertTrue((boolean)openLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)closeLatch.await(5L, TimeUnit.SECONDS));
        TimeUnit.SECONDS.sleep(1L);
        Assert.assertEquals((long)2L, (long)callbacks.get());
    }

    @Slow
    @Test
    public void testSSLOpenClose() throws Exception {
        SslContextFactory sslContextFactory = new SslContextFactory();
        File keystore = MavenTestingUtils.getTestResourceFile((String)"keystore");
        sslContextFactory.setKeyStoreResource(Resource.newResource((File)keystore));
        sslContextFactory.setKeyStorePassword("storepwd");
        sslContextFactory.setKeyManagerPassword("keypwd");
        server.addBean((Object)sslContextFactory);
        server.removeConnector((Connector)connector);
        connector = new ServerConnector(server, sslContextFactory);
        server.addConnector((Connector)connector);
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
            }
        });
        server.start();
        final AtomicInteger callbacks = new AtomicInteger();
        final CountDownLatch openLatch = new CountDownLatch(1);
        final CountDownLatch closeLatch = new CountDownLatch(1);
        connector.addBean((Object)new Connection.Listener.Empty(){

            public void onOpened(Connection connection) {
                callbacks.incrementAndGet();
                openLatch.countDown();
            }

            public void onClosed(Connection connection) {
                callbacks.incrementAndGet();
                closeLatch.countDown();
            }
        });
        Socket socket = sslContextFactory.getSslContext().getSocketFactory().createSocket("localhost", connector.getLocalPort());
        socket.setSoTimeout((int)connector.getIdleTimeout());
        OutputStream output = socket.getOutputStream();
        output.write(("GET / HTTP/1.1\r\nHost: localhost:" + connector.getLocalPort() + "\r\n" + "Connection: close\r\n" + "\r\n").getBytes(StandardCharsets.UTF_8));
        output.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        SimpleHttpResponse response = this.httpParser.readResponse(reader);
        Assert.assertEquals((Object)"200", (Object)response.getCode());
        Assert.assertEquals((long)-1L, (long)reader.read());
        socket.close();
        Assert.assertTrue((boolean)openLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)closeLatch.await(5L, TimeUnit.SECONDS));
        TimeUnit.SECONDS.sleep(1L);
        Assert.assertEquals((long)4L, (long)callbacks.get());
    }
}

