/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AsyncRequestReadTest {
    private static Server server;
    private static ServerConnector connector;
    private static final BlockingQueue<Long> __total;

    @Before
    public void startServer() throws Exception {
        server = new Server();
        connector = new ServerConnector(server);
        connector.setIdleTimeout(10000L);
        server.addConnector((Connector)connector);
    }

    @After
    public void stopServer() throws Exception {
        server.stop();
        server.join();
    }

    @Test
    public void testPipelined() throws Exception {
        server.setHandler((Handler)new AsyncStreamHandler());
        server.start();
        try (Socket socket = new Socket("localhost", connector.getLocalPort());){
            socket.setSoTimeout(1000);
            byte[] content = new byte[131072];
            Arrays.fill(content, (byte)120);
            OutputStream out = socket.getOutputStream();
            String header = "POST / HTTP/1.1\r\nHost: localhost\r\nContent-Length: " + content.length + "\r\n" + "Content-Type: bytes\r\n" + "\r\n";
            byte[] h = header.getBytes(StandardCharsets.ISO_8859_1);
            out.write(h);
            out.write(content);
            header = "POST / HTTP/1.1\r\nHost: localhost\r\nContent-Length: " + content.length + "\r\n" + "Content-Type: bytes\r\n" + "Connection: close\r\n" + "\r\n";
            h = header.getBytes(StandardCharsets.ISO_8859_1);
            out.write(h);
            out.write(content);
            out.flush();
            InputStream in = socket.getInputStream();
            String response = IO.toString((InputStream)in);
            Assert.assertTrue((response.indexOf("200 OK") > 0 ? 1 : 0) != 0);
            long total = __total.poll(5L, TimeUnit.SECONDS);
            Assert.assertEquals((long)content.length, (long)total);
            total = __total.poll(5L, TimeUnit.SECONDS);
            Assert.assertEquals((long)content.length, (long)total);
        }
    }

    @Test
    public void testAsyncReadsWithDelays() throws Exception {
        server.setHandler((Handler)new AsyncStreamHandler());
        server.start();
        this.asyncReadTest(64, 4, 4, 20);
        this.asyncReadTest(256, 16, 16, 50);
        this.asyncReadTest(256, 1, 128, 10);
        this.asyncReadTest(131072, 1, 64, 10);
        this.asyncReadTest(262144, 5321, 10, 100);
        this.asyncReadTest(524288, 32768, 10, 10);
    }

    public void asyncReadTest(int contentSize, int chunkSize, int chunks, int delayMS) throws Exception {
        String tst = contentSize + "," + chunkSize + "," + chunks + "," + delayMS;
        try (Socket socket = new Socket("localhost", connector.getLocalPort());){
            byte[] content = new byte[contentSize];
            Arrays.fill(content, (byte)120);
            OutputStream out = socket.getOutputStream();
            out.write("POST / HTTP/1.1\r\n".getBytes());
            out.write("Host: localhost\r\n".getBytes());
            out.write(("Content-Length: " + content.length + "\r\n").getBytes());
            out.write("Content-Type: bytes\r\n".getBytes());
            out.write("Connection: close\r\n".getBytes());
            out.write("\r\n".getBytes());
            out.flush();
            int offset = 0;
            for (int i = 0; i < chunks; ++i) {
                out.write(content, offset, chunkSize);
                offset += chunkSize;
                Thread.sleep(delayMS);
            }
            out.write(content, offset, content.length - offset);
            out.flush();
            InputStream in = socket.getInputStream();
            String response = IO.toString((InputStream)in);
            Assert.assertTrue((String)tst, (response.indexOf("200 OK") > 0 ? 1 : 0) != 0);
            long total = __total.poll(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)tst, (long)content.length, (long)total);
        }
    }

    @Test
    public void testPartialRead() throws Exception {
        server.setHandler((Handler)new PartialReaderHandler());
        server.start();
        try (Socket socket = new Socket("localhost", connector.getLocalPort());){
            socket.setSoTimeout(1000);
            byte[] content = new byte[131072];
            Arrays.fill(content, (byte)88);
            OutputStream out = socket.getOutputStream();
            String header = "POST /?read=10 HTTP/1.1\r\nHost: localhost\r\nContent-Length: " + content.length + "\r\n" + "Content-Type: bytes\r\n" + "\r\n";
            byte[] h = header.getBytes(StandardCharsets.ISO_8859_1);
            out.write(h);
            out.write(content);
            header = "POST /?read=10 HTTP/1.1\r\nHost: localhost\r\nContent-Length: " + content.length + "\r\n" + "Content-Type: bytes\r\n" + "Connection: close\r\n" + "\r\n";
            h = header.getBytes(StandardCharsets.ISO_8859_1);
            out.write(h);
            out.write(content);
            out.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"Content-Length:"));
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"Server:"));
            in.readLine();
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"XXXXXXX"));
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"Connection: close"));
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"Server:"));
            in.readLine();
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"XXXXXXX"));
        }
    }

    @Test
    public void testPartialReadThenShutdown() throws Exception {
        server.setHandler((Handler)new PartialReaderHandler());
        server.start();
        try (Socket socket = new Socket("localhost", connector.getLocalPort());){
            socket.setSoTimeout(10000);
            byte[] content = new byte[131072];
            Arrays.fill(content, (byte)88);
            OutputStream out = socket.getOutputStream();
            String header = "POST /?read=10 HTTP/1.1\r\nHost: localhost\r\nContent-Length: " + content.length + "\r\n" + "Content-Type: bytes\r\n" + "\r\n";
            byte[] h = header.getBytes(StandardCharsets.ISO_8859_1);
            out.write(h);
            out.write(content, 0, 4096);
            out.flush();
            socket.shutdownOutput();
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"Content-Length:"));
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"Server:"));
            in.readLine();
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"XXXXXXX"));
        }
    }

    @Test
    public void testPartialReadThenClose() throws Exception {
        server.setHandler((Handler)new PartialReaderHandler());
        server.start();
        try (Socket socket = new Socket("localhost", connector.getLocalPort());){
            socket.setSoTimeout(1000);
            byte[] content = new byte[131072];
            Arrays.fill(content, (byte)88);
            OutputStream out = socket.getOutputStream();
            String header = "POST /?read=10 HTTP/1.1\r\nHost: localhost\r\nContent-Length: " + content.length + "\r\n" + "Content-Type: bytes\r\n" + "\r\n";
            byte[] h = header.getBytes(StandardCharsets.ISO_8859_1);
            out.write(h);
            out.write(content, 0, 4096);
            out.flush();
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"Content-Length:"));
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"Server:"));
            in.readLine();
            Assert.assertThat((Object)in.readLine(), (Matcher)Matchers.containsString((String)"XXXXXXX"));
            socket.close();
        }
    }

    static {
        __total = new BlockingArrayQueue();
    }

    private static class PartialReaderHandler
    extends AbstractHandler {
        private PartialReaderHandler() {
        }

        public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            int c;
            int read;
            httpResponse.setStatus(200);
            request.setHandled(true);
            BufferedReader in = request.getReader();
            PrintWriter out = httpResponse.getWriter();
            int i = read = Integer.valueOf(request.getParameter("read")).intValue();
            while (i-- > 0 && (c = in.read()) >= 0) {
                out.write(c);
            }
            out.println();
        }
    }

    private static class AsyncStreamHandler
    extends AbstractHandler {
        private AsyncStreamHandler() {
        }

        public void handle(String path, final Request request, HttpServletRequest httpRequest, final HttpServletResponse httpResponse) throws IOException, ServletException {
            httpResponse.setStatus(500);
            request.setHandled(true);
            final AsyncContext async = request.startAsync();
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long total = 0L;
                    try (ServletInputStream in = request.getInputStream();){
                        int read;
                        byte[] b = new byte[16384];
                        while ((read = in.read(b)) >= 0) {
                            total += (long)read;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        total = -1L;
                    }
                    finally {
                        httpResponse.setStatus(200);
                        async.complete();
                        __total.offer(total);
                    }
                }
            }.start();
        }
    }
}

