/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.toolchain.test.http.SimpleHttpParser;
import org.eclipse.jetty.toolchain.test.http.SimpleHttpResponse;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.StdErrLog;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractHttpTest {
    protected static Server server;
    protected static ServerConnector connector;
    protected String httpVersion;
    protected SimpleHttpParser httpParser;

    public AbstractHttpTest(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    @Before
    public void setUp() throws Exception {
        server = new Server();
        connector = new ServerConnector(server);
        connector.setIdleTimeout(10000L);
        server.addConnector((Connector)connector);
        this.httpParser = new SimpleHttpParser();
        ((StdErrLog)Log.getLogger(HttpChannel.class)).setHideStacks(true);
    }

    @After
    public void tearDown() throws Exception {
        server.stop();
        ((StdErrLog)Log.getLogger(HttpChannel.class)).setHideStacks(false);
    }

    protected SimpleHttpResponse executeRequest() throws URISyntaxException, IOException {
        Socket socket = new Socket("localhost", connector.getLocalPort());
        socket.setSoTimeout((int)connector.getIdleTimeout());
        BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
        String request = "GET / " + this.httpVersion + "\r\n";
        writer.write(request);
        writer.write("Host: localhost");
        writer.println("\r\n");
        writer.flush();
        SimpleHttpResponse response = this.httpParser.readResponse(reader);
        if ("HTTP/1.1".equals(this.httpVersion) && response.getHeaders().get("content-length") == null && response.getHeaders().get("transfer-encoding") == null) {
            Assert.assertThat((String)"If HTTP/1.1 response doesn't contain transfer-encoding or content-length headers, it should contain connection:close", response.getHeaders().get("connection"), (Matcher)Matchers.is((Object)"close"));
        }
        return response;
    }

    protected void assertResponseBody(SimpleHttpResponse response, String expectedResponseBody) {
        Assert.assertThat((String)("response body is" + expectedResponseBody), (Object)response.getBody(), (Matcher)Matchers.is((Object)expectedResponseBody));
    }

    protected void assertHeader(SimpleHttpResponse response, String headerName, String expectedValue) {
        Assert.assertThat((String)(headerName + "=" + expectedValue), response.getHeaders().get(headerName), (Matcher)Matchers.is((Object)expectedValue));
    }

    protected class ThrowExceptionOnDemandHandler
    extends AbstractHandler {
        private final boolean throwException;
        private volatile Throwable failure;

        protected ThrowExceptionOnDemandHandler(boolean throwException) {
            this.throwException = throwException;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (this.throwException) {
                throw new TestCommitException();
            }
        }

        protected void markFailed(Throwable x) {
            this.failure = x;
        }

        public Throwable failure() {
            return this.failure;
        }
    }

    protected static class TestCommitException
    extends IllegalStateException {
        public TestCommitException() {
            super("Thrown by test");
        }
    }
}

