/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Queue;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.Scheduler;

public class ByteArrayEndPoint
extends AbstractEndPoint {
    static final Logger LOG = Log.getLogger(ByteArrayEndPoint.class);
    public static final InetSocketAddress NOIP = new InetSocketAddress(0);
    private static final ByteBuffer EOF = BufferUtil.allocate(0);
    private final Runnable _runFillable = new Runnable(){

        @Override
        public void run() {
            ByteArrayEndPoint.this.getFillInterest().fillable();
        }
    };
    private final Locker _locker = new Locker();
    private final Queue<ByteBuffer> _inQ = new ArrayQueue<ByteBuffer>();
    private ByteBuffer _out;
    private boolean _ishut;
    private boolean _oshut;
    private boolean _closed;
    private boolean _growOutput;

    public ByteArrayEndPoint() {
        this(null, 0L, null, null);
    }

    public ByteArrayEndPoint(byte[] input, int outputSize) {
        this(null, 0L, input != null ? BufferUtil.toBuffer(input) : null, BufferUtil.allocate(outputSize));
    }

    public ByteArrayEndPoint(String input, int outputSize) {
        this(null, 0L, input != null ? BufferUtil.toBuffer(input) : null, BufferUtil.allocate(outputSize));
    }

    public ByteArrayEndPoint(Scheduler scheduler, long idleTimeoutMs) {
        this(scheduler, idleTimeoutMs, null, null);
    }

    public ByteArrayEndPoint(Scheduler timer, long idleTimeoutMs, byte[] input, int outputSize) {
        this(timer, idleTimeoutMs, input != null ? BufferUtil.toBuffer(input) : null, BufferUtil.allocate(outputSize));
    }

    public ByteArrayEndPoint(Scheduler timer, long idleTimeoutMs, String input, int outputSize) {
        this(timer, idleTimeoutMs, input != null ? BufferUtil.toBuffer(input) : null, BufferUtil.allocate(outputSize));
    }

    public ByteArrayEndPoint(Scheduler timer, long idleTimeoutMs, ByteBuffer input, ByteBuffer output) {
        super(timer, NOIP, NOIP);
        if (BufferUtil.hasContent(input)) {
            this.addInput(input);
        }
        this._out = output == null ? BufferUtil.allocate(1024) : output;
        this.setIdleTimeout(idleTimeoutMs);
    }

    @Override
    protected void onIncompleteFlush() {
    }

    protected void execute(Runnable task) {
        new Thread(task, "BAEPoint-" + Integer.toHexString(this.hashCode())).start();
    }

    @Override
    protected void needsFillInterest() throws IOException {
        try (Locker.Lock lock = this._locker.lock();){
            if (this._closed) {
                throw new ClosedChannelException();
            }
            ByteBuffer in = this._inQ.peek();
            if (BufferUtil.hasContent(in) || in == EOF) {
                this.execute(this._runFillable);
            }
        }
    }

    public void addInputEOF() {
        this.addInput((ByteBuffer)null);
    }

    public void addInput(ByteBuffer in) {
        boolean fillable = false;
        try (Locker.Lock lock = this._locker.lock();){
            if (this._inQ.peek() == EOF) {
                throw new RuntimeIOException(new EOFException());
            }
            boolean was_empty = this._inQ.isEmpty();
            if (in == null) {
                this._inQ.add(EOF);
                fillable = true;
            }
            if (BufferUtil.hasContent(in)) {
                this._inQ.add(in);
                fillable = was_empty;
            }
        }
        if (fillable) {
            this._runFillable.run();
        }
    }

    public void addInputAndExecute(ByteBuffer in) {
        boolean fillable = false;
        try (Locker.Lock lock = this._locker.lock();){
            if (this._inQ.peek() == EOF) {
                throw new RuntimeIOException(new EOFException());
            }
            boolean was_empty = this._inQ.isEmpty();
            if (in == null) {
                this._inQ.add(EOF);
                fillable = true;
            }
            if (BufferUtil.hasContent(in)) {
                this._inQ.add(in);
                fillable = was_empty;
            }
        }
        if (fillable) {
            this.execute(this._runFillable);
        }
    }

    public void addInput(String s) {
        this.addInput(BufferUtil.toBuffer(s, StandardCharsets.UTF_8));
    }

    public void addInput(String s, Charset charset) {
        this.addInput(BufferUtil.toBuffer(s, charset));
    }

    public ByteBuffer getOutput() {
        return this._out;
    }

    public String getOutputString() {
        return this.getOutputString(StandardCharsets.UTF_8);
    }

    public String getOutputString(Charset charset) {
        return BufferUtil.toString(this._out, charset);
    }

    public ByteBuffer takeOutput() {
        ByteBuffer b = this._out;
        this._out = BufferUtil.allocate(b.capacity());
        this.getWriteFlusher().completeWrite();
        return b;
    }

    public String takeOutputString() {
        return this.takeOutputString(StandardCharsets.UTF_8);
    }

    public String takeOutputString(Charset charset) {
        ByteBuffer buffer = this.takeOutput();
        return BufferUtil.toString(buffer, charset);
    }

    public void setOutput(ByteBuffer out) {
        this._out = out;
        this.getWriteFlusher().completeWrite();
    }

    @Override
    public boolean isOpen() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = !this._closed;
            return bl;
        }
    }

    @Override
    public boolean isInputShutdown() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._ishut || this._closed;
            return bl;
        }
    }

    @Override
    public boolean isOutputShutdown() {
        try (Locker.Lock lock = this._locker.lock();){
            boolean bl = this._oshut || this._closed;
            return bl;
        }
    }

    public void shutdownInput() {
        boolean close = false;
        try (Locker.Lock lock = this._locker.lock();){
            this._ishut = true;
            if (this._oshut && !this._closed) {
                this._closed = true;
                close = true;
            }
        }
        if (close) {
            super.close();
        }
    }

    @Override
    public void shutdownOutput() {
        boolean close = false;
        try (Locker.Lock lock = this._locker.lock();){
            this._oshut = true;
            if (this._ishut && !this._closed) {
                this._closed = true;
                close = true;
            }
        }
        if (close) {
            super.close();
        }
    }

    @Override
    public void close() {
        boolean close = false;
        try (Locker.Lock lock = this._locker.lock();){
            if (!this._closed) {
                this._oshut = true;
                this._ishut = true;
                this._closed = true;
                close = true;
            }
        }
        if (close) {
            super.close();
        }
    }

    public boolean hasMore() {
        return this.getOutput().position() > 0;
    }

    @Override
    public int fill(ByteBuffer buffer) throws IOException {
        int filled = 0;
        boolean close = false;
        try (Locker.Lock lock = this._locker.lock();){
            while (true) {
                if (this._closed) {
                    throw new EofException("CLOSED");
                }
                if (this._ishut) {
                    int n = -1;
                    return n;
                }
                if (this._inQ.isEmpty()) {
                    break;
                }
                ByteBuffer in = this._inQ.peek();
                if (in == EOF) {
                    this._ishut = true;
                    if (this._oshut) {
                        this._closed = true;
                        close = true;
                    }
                    filled = -1;
                    break;
                }
                if (BufferUtil.hasContent(in)) {
                    filled = BufferUtil.append(buffer, in);
                    if (BufferUtil.isEmpty(in)) {
                        this._inQ.poll();
                    }
                    break;
                }
                this._inQ.poll();
            }
        }
        if (close) {
            super.close();
        }
        if (filled > 0) {
            this.notIdle();
        }
        return filled;
    }

    @Override
    public boolean flush(ByteBuffer ... buffers) throws IOException {
        if (this._closed) {
            throw new IOException("CLOSED");
        }
        if (this._oshut) {
            throw new IOException("OSHUT");
        }
        boolean flushed = true;
        boolean idle = true;
        for (ByteBuffer b : buffers) {
            if (!BufferUtil.hasContent(b)) continue;
            if (this._growOutput && b.remaining() > BufferUtil.space(this._out)) {
                BufferUtil.compact(this._out);
                if (b.remaining() > BufferUtil.space(this._out)) {
                    ByteBuffer n = BufferUtil.allocate(this._out.capacity() + b.remaining() * 2);
                    BufferUtil.append(n, this._out);
                    this._out = n;
                }
            }
            if (BufferUtil.append(this._out, b) > 0) {
                idle = false;
            }
            if (!BufferUtil.hasContent(b)) continue;
            flushed = false;
            break;
        }
        if (!idle) {
            this.notIdle();
        }
        return flushed;
    }

    public void reset() {
        this.getFillInterest().onClose();
        this.getWriteFlusher().onClose();
        this._ishut = false;
        this._oshut = false;
        this._closed = false;
        this._inQ.clear();
        BufferUtil.clear(this._out);
    }

    @Override
    public Object getTransport() {
        return null;
    }

    public boolean isGrowOutput() {
        return this._growOutput;
    }

    public void setGrowOutput(boolean growOutput) {
        this._growOutput = growOutput;
    }
}

