/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.util.QuoteUtil;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.SessionListener;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.WebSocketSessionFactory;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.extensions.ExtensionStack;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.eclipse.jetty.websocket.server.HandshakeRFC6455;
import org.eclipse.jetty.websocket.server.WebSocketHandshake;
import org.eclipse.jetty.websocket.server.WebSocketServerConnection;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class WebSocketServerFactory
extends ContainerLifeCycle
implements WebSocketCreator,
WebSocketContainerScope,
WebSocketServletFactory,
SessionListener {
    private static final Logger LOG = Log.getLogger(WebSocketServerFactory.class);
    private final ClassLoader contextClassloader;
    private final Map<Integer, WebSocketHandshake> handshakes = new HashMap<Integer, WebSocketHandshake>();
    private final Scheduler scheduler = new ScheduledExecutorScheduler();
    private final String supportedVersions;
    private final WebSocketPolicy defaultPolicy;
    private final EventDriverFactory eventDriverFactory;
    private final ByteBufferPool bufferPool;
    private final WebSocketExtensionFactory extensionFactory;
    private Executor executor;
    private List<SessionFactory> sessionFactories;
    private Set<WebSocketSession> openSessions = new CopyOnWriteArraySet<WebSocketSession>();
    private WebSocketCreator creator;
    private List<Class<?>> registeredSocketClasses;
    private DecoratedObjectFactory objectFactory;

    public WebSocketServerFactory() {
        this(WebSocketPolicy.newServerPolicy(), new MappedByteBufferPool());
    }

    public WebSocketServerFactory(WebSocketPolicy policy) {
        this(policy, new MappedByteBufferPool());
    }

    public WebSocketServerFactory(ByteBufferPool bufferPool) {
        this(WebSocketPolicy.newServerPolicy(), bufferPool);
    }

    public WebSocketServerFactory(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this.handshakes.put(13, new HandshakeRFC6455());
        this.addBean(this.scheduler);
        this.addBean(bufferPool);
        this.contextClassloader = Thread.currentThread().getContextClassLoader();
        this.registeredSocketClasses = new ArrayList();
        this.defaultPolicy = policy;
        this.eventDriverFactory = new EventDriverFactory(this.defaultPolicy);
        this.bufferPool = bufferPool;
        this.extensionFactory = new WebSocketExtensionFactory(this);
        this.extensionFactory.unregister("deflate-frame");
        this.extensionFactory.unregister("permessage-deflate");
        this.extensionFactory.unregister("x-webkit-deflate-frame");
        this.sessionFactories = new ArrayList<SessionFactory>();
        this.sessionFactories.add(new WebSocketSessionFactory(this, new SessionListener[0]));
        this.creator = this;
        ArrayList<Integer> versions = new ArrayList<Integer>();
        for (int v : this.handshakes.keySet()) {
            versions.add(v);
        }
        Collections.sort(versions, Collections.reverseOrder());
        StringBuilder rv = new StringBuilder();
        Iterator iterator = versions.iterator();
        while (iterator.hasNext()) {
            int v = (Integer)iterator.next();
            if (rv.length() > 0) {
                rv.append(", ");
            }
            rv.append(v);
        }
        this.supportedVersions = rv.toString();
    }

    @Override
    public boolean acceptWebSocket(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.acceptWebSocket(this.getCreator(), request, response);
    }

    @Override
    public boolean acceptWebSocket(WebSocketCreator creator, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.contextClassloader);
            ServletUpgradeRequest sockreq = new ServletUpgradeRequest(request);
            ServletUpgradeResponse sockresp = new ServletUpgradeResponse(response);
            Object websocketPojo = creator.createWebSocket(sockreq, sockresp);
            websocketPojo = this.getObjectFactory().decorate(websocketPojo);
            if (sockresp.isCommitted()) {
                boolean bl = false;
                return bl;
            }
            if (websocketPojo == null) {
                sockresp.sendError(503, "Endpoint Creation Failed");
                boolean bl = false;
                return bl;
            }
            HttpConnection connection = (HttpConnection)request.getAttribute("org.eclipse.jetty.server.HttpConnection");
            EventDriver driver = this.eventDriverFactory.wrap(websocketPojo);
            boolean bl = this.upgrade(connection, sockreq, sockresp, driver);
            return bl;
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to accept websocket due to mangled URI", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void addSessionFactory(SessionFactory sessionFactory) {
        if (this.sessionFactories.contains(sessionFactory)) {
            return;
        }
        this.sessionFactories.add(sessionFactory);
    }

    @Override
    public void cleanup() {
        try {
            this.stop();
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }

    protected void shutdownAllConnections() {
        for (WebSocketSession session : this.openSessions) {
            if (session.getConnection() == null) continue;
            try {
                session.getConnection().close(1001, "Shutdown");
            }
            catch (Throwable t) {
                LOG.debug("During Shutdown All Connections", t);
            }
        }
        this.openSessions.clear();
    }

    @Override
    public WebSocketServletFactory createFactory(WebSocketPolicy policy) {
        return new WebSocketServerFactory(policy, this.bufferPool);
    }

    private WebSocketSession createSession(URI requestURI, EventDriver websocket, LogicalConnection connection) {
        if (websocket == null) {
            throw new InvalidWebSocketException("Unable to create Session from null websocket");
        }
        for (SessionFactory impl : this.sessionFactories) {
            if (!impl.supports(websocket)) continue;
            try {
                return impl.createSession(requestURI, websocket, connection);
            }
            catch (Throwable e) {
                throw new InvalidWebSocketException("Unable to create Session", e);
            }
        }
        throw new InvalidWebSocketException("Unable to create Session: unrecognized internal EventDriver type: " + websocket.getClass().getName());
    }

    @Override
    public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
        if (this.registeredSocketClasses.size() < 1) {
            throw new WebSocketException("No WebSockets have been registered with the factory.  Cannot use default implementation of WebSocketCreator.");
        }
        if (this.registeredSocketClasses.size() > 1) {
            LOG.warn("You have registered more than 1 websocket object, and are using the default WebSocketCreator! Using first registered websocket.", new Object[0]);
        }
        Class<?> firstClass = this.registeredSocketClasses.get(0);
        try {
            return this.objectFactory.createInstance(firstClass);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new WebSocketException("Unable to create instance of " + firstClass, e);
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this.objectFactory == null) {
            this.objectFactory = new DecoratedObjectFactory();
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this.shutdownAllConnections();
        super.doStop();
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public WebSocketCreator getCreator() {
        return this.creator;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public DecoratedObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public EventDriverFactory getEventDriverFactory() {
        return this.eventDriverFactory;
    }

    @Override
    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    public Set<WebSocketSession> getOpenSessions() {
        return Collections.unmodifiableSet(this.openSessions);
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.defaultPolicy;
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return null;
    }

    public void init(ServletContextHandler context) throws ServletException {
        this.objectFactory = (DecoratedObjectFactory)context.getServletContext().getAttribute(DecoratedObjectFactory.ATTR);
        if (this.objectFactory == null) {
            this.objectFactory = new DecoratedObjectFactory();
        }
        this.executor = context.getServer().getThreadPool();
    }

    @Override
    public void init(ServletContext context) throws ServletException {
        ContextHandler handler;
        this.objectFactory = (DecoratedObjectFactory)context.getAttribute(DecoratedObjectFactory.ATTR);
        if (this.objectFactory == null) {
            this.objectFactory = new DecoratedObjectFactory();
        }
        if ((handler = ContextHandler.getContextHandler(context)) == null) {
            throw new ServletException("Not running on Jetty, WebSocket support unavailable");
        }
        this.executor = handler.getServer().getThreadPool();
        try {
            this.start();
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    @Override
    public boolean isUpgradeRequest(HttpServletRequest request, HttpServletResponse response) {
        if (!"GET".equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        String connection = request.getHeader("connection");
        if (connection == null) {
            return false;
        }
        boolean foundUpgradeToken = false;
        Iterator<String> iter = QuoteUtil.splitAt(connection, ",");
        while (iter.hasNext()) {
            String token = iter.next();
            if (!"upgrade".equalsIgnoreCase(token)) continue;
            foundUpgradeToken = true;
            break;
        }
        if (!foundUpgradeToken) {
            return false;
        }
        String upgrade = request.getHeader("Upgrade");
        if (upgrade == null) {
            return false;
        }
        if (!"websocket".equalsIgnoreCase(upgrade)) {
            LOG.debug("Not a 'Upgrade: WebSocket' (was [Upgrade: " + upgrade + "])", new Object[0]);
            return false;
        }
        if (!"HTTP/1.1".equals(request.getProtocol())) {
            LOG.debug("Not a 'HTTP/1.1' request (was [" + request.getProtocol() + "])", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public void onSessionClosed(WebSocketSession session) {
        this.openSessions.remove(session);
    }

    @Override
    public void onSessionOpened(WebSocketSession session) {
        this.openSessions.add(session);
    }

    protected String[] parseProtocols(String protocol) {
        if (protocol == null) {
            return new String[]{null};
        }
        if ((protocol = protocol.trim()).length() == 0) {
            return new String[]{null};
        }
        String[] passed = protocol.split("\\s*,\\s*");
        String[] protocols = new String[passed.length + 1];
        System.arraycopy(passed, 0, protocols, 0, passed.length);
        return protocols;
    }

    @Override
    public void register(Class<?> websocketPojo) {
        this.registeredSocketClasses.add(websocketPojo);
    }

    @Override
    public void setCreator(WebSocketCreator creator) {
        this.creator = creator;
    }

    private boolean upgrade(HttpConnection http, ServletUpgradeRequest request, ServletUpgradeResponse response, EventDriver driver) throws IOException {
        WebSocketHandshake handshaker;
        if (!"websocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
            throw new IllegalStateException("Not a 'WebSocket: Upgrade' request");
        }
        if (!"HTTP/1.1".equals(request.getHttpVersion())) {
            throw new IllegalStateException("Not a 'HTTP/1.1' request");
        }
        int version = request.getHeaderInt("Sec-WebSocket-Version");
        if (version < 0) {
            version = request.getHeaderInt("Sec-WebSocket-Draft");
        }
        if ((handshaker = this.handshakes.get(version)) == null) {
            StringBuilder warn = new StringBuilder();
            warn.append("Client ").append(request.getRemoteAddress());
            warn.append(" (:").append(request.getRemotePort());
            warn.append(") User Agent: ");
            String ua = request.getHeader("User-Agent");
            if (ua == null) {
                warn.append("[unset] ");
            } else {
                warn.append('\"').append(ua.replaceAll("<", "&lt;")).append("\" ");
            }
            warn.append("requested WebSocket version [").append(version);
            warn.append("], Jetty supports version");
            if (this.handshakes.size() > 1) {
                warn.append('s');
            }
            warn.append(": [").append(this.supportedVersions).append("]");
            LOG.warn(warn.toString(), new Object[0]);
            response.setHeader("Sec-WebSocket-Version", this.supportedVersions);
            response.sendError(400, "Unsupported websocket version specification");
            return false;
        }
        ExtensionStack extensionStack = new ExtensionStack(this.getExtensionFactory());
        if (response.isExtensionsNegotiated()) {
            extensionStack.negotiate(response.getExtensions());
        } else {
            extensionStack.negotiate(request.getExtensions());
        }
        EndPoint endp = http.getEndPoint();
        Connector connector = http.getConnector();
        Executor executor = connector.getExecutor();
        ByteBufferPool bufferPool = connector.getByteBufferPool();
        WebSocketServerConnection wsConnection = new WebSocketServerConnection(endp, executor, this.scheduler, driver.getPolicy(), bufferPool);
        extensionStack.setPolicy(driver.getPolicy());
        extensionStack.configure(wsConnection.getParser());
        extensionStack.configure(wsConnection.getGenerator());
        if (LOG.isDebugEnabled()) {
            LOG.debug("HttpConnection: {}", http);
            LOG.debug("WebSocketConnection: {}", wsConnection);
        }
        WebSocketSession session = this.createSession(request.getRequestURI(), driver, wsConnection);
        session.setPolicy(driver.getPolicy());
        session.setUpgradeRequest(request);
        response.setExtensions(extensionStack.getNegotiatedExtensions());
        session.setUpgradeResponse(response);
        wsConnection.setSession(session);
        wsConnection.setNextIncomingFrames(extensionStack);
        extensionStack.setNextIncoming(session);
        session.setOutgoingHandler(extensionStack);
        extensionStack.setNextOutgoing(wsConnection);
        session.addBean(extensionStack);
        this.addBean(session);
        if (session.isFailed()) {
            throw new IOException("Session failed to start");
        }
        if (!session.isRunning()) {
            try {
                session.start();
            }
            catch (Exception e) {
                throw new IOException("Unable to start Session", e);
            }
        }
        request.setServletAttribute("org.eclipse.jetty.server.HttpConnection.UPGRADE", wsConnection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handshake Response: {}", handshaker);
        }
        handshaker.doHandshakeResponse(request, response);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Websocket upgrade {} {} {} {}", request.getRequestURI(), version, response.getAcceptedSubProtocol(), wsConnection);
        }
        return true;
    }
}

