/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.AsyncContextState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class RequestLogHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(RequestLogHandler.class);
    private RequestLog _requestLog;
    private final AsyncListener _listener = new AsyncListener(){

        @Override
        public void onTimeout(AsyncEvent event) throws IOException {
        }

        @Override
        public void onStartAsync(AsyncEvent event) throws IOException {
            event.getAsyncContext().addListener(this);
        }

        @Override
        public void onError(AsyncEvent event) throws IOException {
        }

        @Override
        public void onComplete(AsyncEvent event) throws IOException {
            AsyncContextState context = (AsyncContextState)event.getAsyncContext();
            Request request = context.getHttpChannelState().getBaseRequest();
            Response response = request.getResponse();
            RequestLogHandler.this._requestLog.log(request, response);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            super.handle(target, baseRequest, request, response);
        }
        finally {
            if (this._requestLog != null && baseRequest.getDispatcherType().equals((Object)DispatcherType.REQUEST)) {
                if (baseRequest.getHttpChannelState().isAsync()) {
                    if (baseRequest.getHttpChannelState().isInitial()) {
                        baseRequest.getAsyncContext().addListener(this._listener);
                    }
                } else {
                    this._requestLog.log(baseRequest, (Response)response);
                }
            }
        }
    }

    public void setRequestLog(RequestLog requestLog) {
        this.updateBean(this._requestLog, requestLog);
        this._requestLog = requestLog;
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }

    @Override
    protected void doStart() throws Exception {
        if (this._requestLog == null) {
            LOG.warn("!RequestLog", new Object[0]);
            this._requestLog = new NullRequestLog();
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this._requestLog instanceof NullRequestLog) {
            this._requestLog = null;
        }
    }

    private static class NullRequestLog
    extends AbstractLifeCycle
    implements RequestLog {
        private NullRequestLog() {
        }

        @Override
        public void log(Request request, Response response) {
        }
    }
}

