/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.message.MessageAppender;

public class MessageInputStream
extends InputStream
implements MessageAppender {
    private static final Logger LOG = Log.getLogger(MessageInputStream.class);
    private final LogicalConnection connection;
    private final BlockingDeque<ByteBuffer> buffers = new LinkedBlockingDeque<ByteBuffer>();
    private AtomicBoolean closed = new AtomicBoolean(false);
    private AtomicBoolean buffersExhausted = new AtomicBoolean(false);
    private ByteBuffer activeBuffer = null;

    public MessageInputStream(LogicalConnection connection) {
        this.connection = connection;
    }

    @Override
    public void appendMessage(ByteBuffer payload, boolean isLast) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("appendMessage(ByteBuffer,{}): {}", isLast, BufferUtil.toDetailString(payload));
        }
        if (this.buffersExhausted.get()) {
            throw new RuntimeException("Last frame already received");
        }
        if (this.closed.get()) {
            return;
        }
        try {
            this.buffers.put(payload);
            if (isLast) {
                this.buffersExhausted.set(true);
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed.set(true);
        super.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void messageComplete() {
        LOG.debug("messageComplete()", new Object[0]);
        this.buffersExhausted.set(true);
        try {
            this.buffers.put(ByteBuffer.wrap(new byte[0]));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public int read() throws IOException {
        LOG.debug("read()", new Object[0]);
        try {
            if (this.closed.get()) {
                return -1;
            }
            if (this.activeBuffer == null) {
                this.activeBuffer = this.buffers.take();
            }
            while (this.activeBuffer.remaining() <= 0) {
                if (this.buffersExhausted.get()) {
                    this.closed.set(true);
                    return -1;
                }
                this.activeBuffer = this.buffers.take();
            }
            return this.activeBuffer.get();
        }
        catch (InterruptedException e) {
            LOG.warn(e);
            this.closed.set(true);
            return -1;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("reset() not supported");
    }
}

