/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;
import java.security.Permission;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.BadResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.URLResource;

public class FileResource
extends URLResource {
    private static final Logger LOG = Log.getLogger(FileResource.class);
    private File _file;
    private transient URL _alias = null;
    private transient boolean _aliasChecked = false;

    public FileResource(URL url) throws IOException, URISyntaxException {
        super(url, null);
        try {
            this._file = new File(new URI(url.toString()));
        }
        catch (URISyntaxException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.ignore(e);
            try {
                String file_url = "file:" + URIUtil.encodePath(url.toString().substring(5));
                URI uri = new URI(file_url);
                this._file = uri.getAuthority() == null ? new File(uri) : new File("//" + uri.getAuthority() + URIUtil.decodePath(url.getFile()));
            }
            catch (Exception e2) {
                LOG.ignore(e2);
                this.checkConnection();
                Permission perm = this._connection.getPermission();
                this._file = new File(perm == null ? url.getFile() : perm.getName());
            }
        }
        if (this._file.isDirectory()) {
            if (!this._urlString.endsWith("/")) {
                this._urlString = this._urlString + "/";
            }
        } else if (this._urlString.endsWith("/")) {
            this._urlString = this._urlString.substring(0, this._urlString.length() - 1);
        }
    }

    FileResource(URL url, URLConnection connection, File file) {
        super(url, connection);
        this._file = file;
        if (this._file.isDirectory() && !this._urlString.endsWith("/")) {
            this._urlString = this._urlString + "/";
        }
    }

    @Override
    public Resource addPath(String path) throws IOException, MalformedURLException {
        URLResource r = null;
        String url = null;
        if ("/".equals(path = URIUtil.canonicalPath(path))) {
            return this;
        }
        if (!this.isDirectory()) {
            r = (FileResource)super.addPath(path);
            url = r._urlString;
        } else {
            if (path == null) {
                throw new MalformedURLException();
            }
            String rel = path;
            if (path.startsWith("/")) {
                rel = path.substring(1);
            }
            url = URIUtil.addPaths(this._urlString, URIUtil.encodePath(rel));
            r = (URLResource)Resource.newResource(url);
        }
        String encoded = URIUtil.encodePath(path);
        int expected = r.toString().length() - encoded.length();
        int index = r._urlString.lastIndexOf(encoded, expected);
        if (!(expected == index || expected - 1 == index && !path.endsWith("/") && r.isDirectory() || r instanceof BadResource)) {
            ((FileResource)r)._alias = new URL(url);
            ((FileResource)r)._aliasChecked = true;
        }
        return r;
    }

    @Override
    public URL getAlias() {
        if (!this._aliasChecked) {
            try {
                String abs = this._file.getAbsolutePath();
                String can = this._file.getCanonicalPath();
                if (abs.length() != can.length() || !abs.equals(can)) {
                    this._alias = Resource.toURL(new File(can));
                }
                this._aliasChecked = true;
                if (this._alias != null && LOG.isDebugEnabled()) {
                    LOG.debug("ALIAS abs=" + abs, new Object[0]);
                    LOG.debug("ALIAS can=" + can, new Object[0]);
                }
            }
            catch (Exception e) {
                LOG.warn("EXCEPTION ", e);
                return this.getURL();
            }
        }
        return this._alias;
    }

    @Override
    public boolean exists() {
        return this._file.exists();
    }

    @Override
    public long lastModified() {
        return this._file.lastModified();
    }

    @Override
    public boolean isDirectory() {
        return this._file.isDirectory();
    }

    @Override
    public long length() {
        return this._file.length();
    }

    @Override
    public String getName() {
        return this._file.getAbsolutePath();
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    @Override
    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return FileChannel.open(this._file.toPath(), StandardOpenOption.READ);
    }

    @Override
    public OutputStream getOutputStream() throws IOException, SecurityException {
        return new FileOutputStream(this._file);
    }

    @Override
    public boolean delete() throws SecurityException {
        return this._file.delete();
    }

    @Override
    public boolean renameTo(Resource dest) throws SecurityException {
        if (dest instanceof FileResource) {
            return this._file.renameTo(((FileResource)dest)._file);
        }
        return false;
    }

    @Override
    public String[] list() {
        String[] list = this._file.list();
        if (list == null) {
            return null;
        }
        int i = list.length;
        while (i-- > 0) {
            if (!new File(this._file, list[i]).isDirectory() || list[i].endsWith("/")) continue;
            int n = i;
            list[n] = list[n] + "/";
        }
        return list;
    }

    @Override
    public String encode(String uri) {
        return uri;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || !(o instanceof FileResource)) {
            return false;
        }
        FileResource f = (FileResource)o;
        return f._file == this._file || null != this._file && this._file.equals(f._file);
    }

    @Override
    public int hashCode() {
        return null == this._file ? super.hashCode() : this._file.hashCode();
    }

    @Override
    public void copyTo(File destination) throws IOException {
        if (this.isDirectory()) {
            IO.copyDir(this.getFile(), destination);
        } else {
            if (destination.exists()) {
                throw new IllegalArgumentException(destination + " exists");
            }
            IO.copy(this.getFile(), destination);
        }
    }
}

