/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.Generator;

public class WriteBytesProvider
implements Callback {
    private static final Logger LOG = Log.getLogger(WriteBytesProvider.class);
    private final Generator generator;
    private final Callback flushCallback;
    private LinkedList<FrameEntry> queue;
    private int bufferSize = 2048;
    private FrameEntry active;
    private Throwable failure;
    private ByteBuffer buffer;
    private AtomicBoolean closed;

    public WriteBytesProvider(Generator generator, Callback flushCallback) {
        this.generator = Objects.requireNonNull(generator);
        this.flushCallback = Objects.requireNonNull(flushCallback);
        this.queue = new LinkedList();
        this.closed = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Frame frame, Callback callback) {
        Objects.requireNonNull(frame);
        LOG.debug("enqueue({}, {})", frame, callback);
        WriteBytesProvider writeBytesProvider = this;
        synchronized (writeBytesProvider) {
            if (this.closed.get()) {
                LOG.debug("Write is closed: {}", frame, callback);
                if (callback != null) {
                    callback.failed(new IOException("Write is closed"));
                }
                return;
            }
            if (this.isFailed()) {
                this.notifyFailure(callback);
                return;
            }
            FrameEntry entry = new FrameEntry(frame, callback);
            switch (frame.getType()) {
                case PING: {
                    this.queue.addFirst(entry);
                    break;
                }
                case CLOSE: {
                    this.closed.set(true);
                    this.queue.addLast(entry);
                    break;
                }
                default: {
                    this.queue.addLast(entry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failAll(Throwable t) {
        WriteBytesProvider writeBytesProvider = this;
        synchronized (writeBytesProvider) {
            if (this.isFailed()) {
                return;
            }
            this.failure = t;
            for (FrameEntry fe : this.queue) {
                this.notifyFailure(fe.callback);
            }
            this.queue.clear();
            this.flushCallback.failed(this.failure);
        }
    }

    @Override
    public void failed(Throwable cause) {
        this.failAll(cause);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getByteBuffer() {
        WriteBytesProvider writeBytesProvider = this;
        synchronized (writeBytesProvider) {
            if (this.active == null) {
                if (this.queue.isEmpty()) {
                    return null;
                }
                this.active = this.queue.pop();
            }
            if (this.active == null) {
                return null;
            }
            this.buffer = this.active.getByteBuffer();
        }
        return this.buffer;
    }

    public Throwable getFailure() {
        return this.failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        WriteBytesProvider writeBytesProvider = this;
        synchronized (writeBytesProvider) {
            return this.closed.get();
        }
    }

    public boolean isFailed() {
        return this.failure != null;
    }

    private void notifyFailure(Callback callback) {
        if (callback == null) {
            return;
        }
        callback.failed(this.failure);
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void succeeded() {
        WriteBytesProvider writeBytesProvider = this;
        synchronized (writeBytesProvider) {
            this.generator.getBufferPool().release(this.buffer);
            if (this.active == null) {
                return;
            }
            if (this.active.frame.remaining() <= 0) {
                if (this.active.callback != null) {
                    try {
                        this.active.callback.succeeded();
                    }
                    catch (Throwable t) {
                        LOG.warn("Callback failure", t);
                    }
                }
                this.active = null;
            }
            this.flushCallback.succeeded();
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WriteBytesProvider[");
        b.append("flushCallback=").append(this.flushCallback);
        if (this.isFailed()) {
            b.append(",FAILURE=").append(this.failure.getClass().getName());
            b.append(",").append(this.failure.getMessage());
        } else {
            b.append(",active=").append(this.active);
            b.append(",queue.size=").append(this.queue.size());
        }
        b.append(']');
        return b.toString();
    }

    private class FrameEntry {
        protected final Frame frame;
        protected final Callback callback;

        public FrameEntry(Frame frame, Callback callback) {
            this.frame = frame;
            this.callback = callback;
        }

        public ByteBuffer getByteBuffer() {
            ByteBuffer buffer = WriteBytesProvider.this.generator.generate(WriteBytesProvider.this.bufferSize, this.frame);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getByteBuffer() - {}", BufferUtil.toDetailString(buffer));
            }
            return buffer;
        }
    }
}

