/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;
import org.eclipse.jetty.server.session.JDBCSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Logger;

public class JDBCSessionIdManager
extends AbstractSessionIdManager {
    static final Logger LOG = SessionHandler.LOG;
    protected final HashSet<String> _sessionIds = new HashSet();
    protected Server _server;
    protected Driver _driver;
    protected String _driverClassName;
    protected String _connectionUrl;
    protected DataSource _datasource;
    protected String _jndiName;
    protected String _sessionIdTable = "JettySessionIds";
    protected String _sessionTable = "JettySessions";
    protected String _sessionTableRowId = "rowId";
    protected Timer _timer;
    protected TimerTask _task;
    protected long _lastScavengeTime;
    protected long _scavengeIntervalMs = 600000L;
    protected String _blobType;
    protected String _longType;
    protected String _createSessionIdTable;
    protected String _createSessionTable;
    protected String _selectBoundedExpiredSessions;
    protected String _deleteOldExpiredSessions;
    protected String _insertId;
    protected String _deleteId;
    protected String _queryId;
    protected String _insertSession;
    protected String _deleteSession;
    protected String _updateSession;
    protected String _updateSessionNode;
    protected String _updateSessionAccessTime;
    protected DatabaseAdaptor _dbAdaptor;
    private String _selectExpiredSessions;

    public JDBCSessionIdManager(Server server) {
        this._server = server;
    }

    public JDBCSessionIdManager(Server server, Random random) {
        super(random);
        this._server = server;
    }

    public void setDriverInfo(String driverClassName, String connectionUrl) {
        this._driverClassName = driverClassName;
        this._connectionUrl = connectionUrl;
    }

    public void setDriverInfo(Driver driverClass, String connectionUrl) {
        this._driver = driverClass;
        this._connectionUrl = connectionUrl;
    }

    public void setDatasource(DataSource ds) {
        this._datasource = ds;
    }

    public DataSource getDataSource() {
        return this._datasource;
    }

    public String getDriverClassName() {
        return this._driverClassName;
    }

    public String getConnectionUrl() {
        return this._connectionUrl;
    }

    public void setDatasourceName(String jndi) {
        this._jndiName = jndi;
    }

    public String getDatasourceName() {
        return this._jndiName;
    }

    public void setBlobType(String name) {
        this._blobType = name;
    }

    public String getBlobType() {
        return this._blobType;
    }

    public String getLongType() {
        return this._longType;
    }

    public void setLongType(String longType) {
        this._longType = longType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengeInterval(long sec) {
        long period;
        if (sec <= 0L) {
            sec = 60L;
        }
        long old_period = this._scavengeIntervalMs;
        this._scavengeIntervalMs = period = sec * 1000L;
        long tenPercent = this._scavengeIntervalMs / 10L;
        if (System.currentTimeMillis() % 2L == 0L) {
            this._scavengeIntervalMs += tenPercent;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scavenging every " + this._scavengeIntervalMs + " ms", new Object[0]);
        }
        if (this._timer != null && (period != old_period || this._task == null)) {
            JDBCSessionIdManager jDBCSessionIdManager = this;
            synchronized (jDBCSessionIdManager) {
                if (this._task != null) {
                    this._task.cancel();
                }
                this._task = new TimerTask(){

                    @Override
                    public void run() {
                        JDBCSessionIdManager.this.scavenge();
                    }
                };
                this._timer.schedule(this._task, this._scavengeIntervalMs, this._scavengeIntervalMs);
            }
        }
    }

    public long getScavengeInterval() {
        return this._scavengeIntervalMs / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSession(HttpSession session) {
        if (session == null) {
            return;
        }
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            String id = ((JDBCSessionManager.Session)session).getClusterId();
            try {
                this.insert(id);
                this._sessionIds.add(id);
            }
            catch (Exception e) {
                LOG.warn("Problem storing session id=" + id, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(String id) {
        if (id == null) {
            return;
        }
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            try {
                this.insert(id);
                this._sessionIds.add(id);
            }
            catch (Exception e) {
                LOG.warn("Problem storing session id=" + id, e);
            }
        }
    }

    @Override
    public void removeSession(HttpSession session) {
        if (session == null) {
            return;
        }
        this.removeSession(((JDBCSessionManager.Session)session).getClusterId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String id) {
        if (id == null) {
            return;
        }
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing session id=" + id, new Object[0]);
            }
            try {
                this._sessionIds.remove(id);
                this.delete(id);
            }
            catch (Exception e) {
                LOG.warn("Problem removing session id=" + id, e);
            }
        }
    }

    @Override
    public String getClusterId(String nodeId) {
        int dot = nodeId.lastIndexOf(46);
        return dot > 0 ? nodeId.substring(0, dot) : nodeId;
    }

    @Override
    public String getNodeId(String clusterId, HttpServletRequest request) {
        if (this._workerName != null) {
            return clusterId + '.' + this._workerName;
        }
        return clusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean idInUse(String id) {
        if (id == null) {
            return false;
        }
        String clusterId = this.getClusterId(id);
        boolean inUse = false;
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            inUse = this._sessionIds.contains(clusterId);
        }
        if (inUse) {
            return true;
        }
        try {
            return this.exists(clusterId);
        }
        catch (Exception e) {
            LOG.warn("Problem checking inUse for id=" + clusterId, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAll(String id) {
        this.removeSession(id);
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; contexts != null && i < contexts.length; ++i) {
                SessionManager manager;
                SessionHandler sessionHandler = ((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
                if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof JDBCSessionManager)) continue;
                ((JDBCSessionManager)manager).invalidateSession(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renewSessionId(String oldClusterId, String oldNodeId, HttpServletRequest request) {
        String newClusterId = this.newSessionId(request.hashCode());
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            this.removeSession(oldClusterId);
            this.addSession(newClusterId);
            Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; contexts != null && i < contexts.length; ++i) {
                SessionManager manager;
                SessionHandler sessionHandler = ((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
                if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof JDBCSessionManager)) continue;
                ((JDBCSessionManager)manager).renewSessionId(oldClusterId, oldNodeId, newClusterId, this.getNodeId(newClusterId, request));
            }
        }
    }

    @Override
    public void doStart() {
        try {
            this.initializeDatabase();
            this.prepareTables();
            this.cleanExpiredSessions();
            super.doStart();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scavenging interval = " + this.getScavengeInterval() + " sec", new Object[0]);
            }
            this._timer = new Timer("JDBCSessionScavenger", true);
            this.setScavengeInterval(this.getScavengeInterval());
        }
        catch (Exception e) {
            LOG.warn("Problem initialising JettySessionIds table", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStop() throws Exception {
        JDBCSessionIdManager jDBCSessionIdManager = this;
        synchronized (jDBCSessionIdManager) {
            if (this._task != null) {
                this._task.cancel();
            }
            if (this._timer != null) {
                this._timer.cancel();
            }
            this._timer = null;
        }
        this._sessionIds.clear();
        super.doStop();
    }

    protected Connection getConnection() throws SQLException {
        if (this._datasource != null) {
            return this._datasource.getConnection();
        }
        return DriverManager.getConnection(this._connectionUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareTables() throws SQLException {
        this._createSessionIdTable = "create table " + this._sessionIdTable + " (id varchar(120), primary key(id))";
        this._selectBoundedExpiredSessions = "select * from " + this._sessionTable + " where expiryTime >= ? and expiryTime <= ?";
        this._selectExpiredSessions = "select * from " + this._sessionTable + " where expiryTime >0 and expiryTime <= ?";
        this._deleteOldExpiredSessions = "delete from " + this._sessionTable + " where expiryTime >0 and expiryTime <= ?";
        this._insertId = "insert into " + this._sessionIdTable + " (id)  values (?)";
        this._deleteId = "delete from " + this._sessionIdTable + " where id = ?";
        this._queryId = "select * from " + this._sessionIdTable + " where id = ?";
        try (Connection connection = null;){
            connection = this.getConnection();
            connection.setAutoCommit(true);
            DatabaseMetaData metaData = connection.getMetaData();
            this._dbAdaptor = new DatabaseAdaptor(metaData);
            this._sessionTableRowId = this._dbAdaptor.getRowIdColumnName();
            String tableName = this._dbAdaptor.convertIdentifier(this._sessionIdTable);
            ResultSet result = metaData.getTables(null, null, tableName, null);
            if (!result.next()) {
                connection.createStatement().executeUpdate(this._createSessionIdTable);
            }
            if (!(result = metaData.getTables(null, null, tableName = this._dbAdaptor.convertIdentifier(this._sessionTable), null)).next()) {
                String blobType = this._dbAdaptor.getBlobType();
                String longType = this._dbAdaptor.getLongType();
                this._createSessionTable = "create table " + this._sessionTable + " (" + this._sessionTableRowId + " varchar(120), sessionId varchar(120), " + " contextPath varchar(60), virtualHost varchar(60), lastNode varchar(60), accessTime " + longType + ", " + " lastAccessTime " + longType + ", createTime " + longType + ", cookieTime " + longType + ", " + " lastSavedTime " + longType + ", expiryTime " + longType + ", map " + blobType + ", primary key(" + this._sessionTableRowId + "))";
                connection.createStatement().executeUpdate(this._createSessionTable);
            }
            String index1 = "idx_" + this._sessionTable + "_expiry";
            String index2 = "idx_" + this._sessionTable + "_session";
            result = metaData.getIndexInfo(null, null, tableName, false, false);
            boolean index1Exists = false;
            boolean index2Exists = false;
            while (result.next()) {
                String idxName = result.getString("INDEX_NAME");
                if (index1.equalsIgnoreCase(idxName)) {
                    index1Exists = true;
                    continue;
                }
                if (!index2.equalsIgnoreCase(idxName)) continue;
                index2Exists = true;
            }
            if (!index1Exists || !index2Exists) {
                Statement statement = connection.createStatement();
                if (!index1Exists) {
                    statement.executeUpdate("create index " + index1 + " on " + this._sessionTable + " (expiryTime)");
                }
                if (!index2Exists) {
                    statement.executeUpdate("create index " + index2 + " on " + this._sessionTable + " (sessionId, contextPath)");
                }
            }
            this._insertSession = "insert into " + this._sessionTable + " (" + this._sessionTableRowId + ", sessionId, contextPath, virtualHost, lastNode, accessTime, lastAccessTime, createTime, cookieTime, lastSavedTime, expiryTime, map) " + " values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            this._deleteSession = "delete from " + this._sessionTable + " where " + this._sessionTableRowId + " = ?";
            this._updateSession = "update " + this._sessionTable + " set sessionId = ?, lastNode = ?, accessTime = ?, lastAccessTime = ?, lastSavedTime = ?, expiryTime = ?, map = ? where " + this._sessionTableRowId + " = ?";
            this._updateSessionNode = "update " + this._sessionTable + " set lastNode = ? where " + this._sessionTableRowId + " = ?";
            this._updateSessionAccessTime = "update " + this._sessionTable + " set lastNode = ?, accessTime = ?, lastAccessTime = ?, lastSavedTime = ?, expiryTime = ? where " + this._sessionTableRowId + " = ?";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(String id) throws SQLException {
        try (Connection connection = null;){
            connection = this.getConnection();
            connection.setAutoCommit(true);
            PreparedStatement query = connection.prepareStatement(this._queryId);
            query.setString(1, id);
            ResultSet result = query.executeQuery();
            if (!result.next()) {
                PreparedStatement statement = connection.prepareStatement(this._insertId);
                statement.setString(1, id);
                statement.executeUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(String id) throws SQLException {
        try (Connection connection = null;){
            connection = this.getConnection();
            connection.setAutoCommit(true);
            PreparedStatement statement = connection.prepareStatement(this._deleteId);
            statement.setString(1, id);
            statement.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(String id) throws SQLException {
        try (Connection connection = null;){
            connection = this.getConnection();
            connection.setAutoCommit(true);
            PreparedStatement statement = connection.prepareStatement(this._queryId);
            statement.setString(1, id);
            ResultSet result = statement.executeQuery();
            boolean bl = result.next();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge() {
        Connection connection = null;
        ArrayList<String> expiredSessionIds = new ArrayList<String>();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scavenge sweep started at " + System.currentTimeMillis(), new Object[0]);
            }
            if (this._lastScavengeTime > 0L) {
                connection = this.getConnection();
                connection.setAutoCommit(true);
                PreparedStatement statement = connection.prepareStatement(this._selectBoundedExpiredSessions);
                long lowerBound = this._lastScavengeTime - this._scavengeIntervalMs;
                long upperBound = this._lastScavengeTime;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" Searching for sessions expired between " + lowerBound + " and " + upperBound, new Object[0]);
                }
                statement.setLong(1, lowerBound);
                statement.setLong(2, upperBound);
                ResultSet result = statement.executeQuery();
                while (result.next()) {
                    String sessionId = result.getString("sessionId");
                    expiredSessionIds.add(sessionId);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(" Found expired sessionId=" + sessionId, new Object[0]);
                }
                Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
                for (int i = 0; contexts != null && i < contexts.length; ++i) {
                    SessionManager manager;
                    SessionHandler sessionHandler = ((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
                    if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof JDBCSessionManager)) continue;
                    ((JDBCSessionManager)manager).expire(expiredSessionIds);
                }
                upperBound = this._lastScavengeTime - 2L * this._scavengeIntervalMs;
                if (upperBound > 0L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Deleting old expired sessions expired before " + upperBound, new Object[0]);
                    }
                    statement = connection.prepareStatement(this._deleteOldExpiredSessions);
                    statement.setLong(1, upperBound);
                    int rows = statement.executeUpdate();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Deleted " + rows + " rows", new Object[0]);
                    }
                }
            }
        }
        catch (Exception e) {
            if (this.isRunning()) {
                LOG.warn("Problem selecting expired sessions", e);
            } else {
                LOG.ignore(e);
            }
        }
        finally {
            this._lastScavengeTime = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scavenge sweep ended at " + this._lastScavengeTime, new Object[0]);
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    LOG.warn(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanExpiredSessions() throws Exception {
        Connection connection = null;
        ArrayList<String> expiredSessionIds = new ArrayList<String>();
        try {
            connection = this.getConnection();
            connection.setTransactionIsolation(8);
            connection.setAutoCommit(false);
            PreparedStatement statement = connection.prepareStatement(this._selectExpiredSessions);
            long now = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Searching for sessions expired before {}", now);
            }
            statement.setLong(1, now);
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                String sessionId = result.getString("sessionId");
                expiredSessionIds.add(sessionId);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Found expired sessionId={}", sessionId);
            }
            Statement sessionsTableStatement = null;
            Statement sessionIdsTableStatement = null;
            if (!expiredSessionIds.isEmpty()) {
                sessionsTableStatement = connection.createStatement();
                sessionsTableStatement.executeUpdate(this.createCleanExpiredSessionsSql("delete from " + this._sessionTable + " where sessionId in ", expiredSessionIds));
                sessionIdsTableStatement = connection.createStatement();
                sessionIdsTableStatement.executeUpdate(this.createCleanExpiredSessionsSql("delete from " + this._sessionIdTable + " where id in ", expiredSessionIds));
            }
            connection.commit();
            HashSet<String> hashSet = this._sessionIds;
            synchronized (hashSet) {
                this._sessionIds.removeAll(expiredSessionIds);
            }
        }
        catch (Exception e) {
            if (connection != null) {
                connection.rollback();
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                LOG.warn(e);
            }
        }
    }

    private String createCleanExpiredSessionsSql(String sql, Collection<String> expiredSessionIds) throws Exception {
        StringBuffer buff = new StringBuffer();
        buff.append(sql);
        buff.append("(");
        Iterator<String> itor = expiredSessionIds.iterator();
        while (itor.hasNext()) {
            buff.append("'" + itor.next() + "'");
            if (!itor.hasNext()) continue;
            buff.append(",");
        }
        buff.append(")");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cleaning expired sessions with: {}", buff);
        }
        return buff.toString();
    }

    private void initializeDatabase() throws Exception {
        if (this._datasource != null) {
            return;
        }
        if (this._jndiName != null) {
            InitialContext ic = new InitialContext();
            this._datasource = (DataSource)ic.lookup(this._jndiName);
        } else if (this._driver != null && this._connectionUrl != null) {
            DriverManager.registerDriver(this._driver);
        } else if (this._driverClassName != null && this._connectionUrl != null) {
            Class.forName(this._driverClassName);
        } else {
            throw new IllegalStateException("No database configured for sessions");
        }
    }

    public class DatabaseAdaptor {
        String _dbName;
        boolean _isLower;
        boolean _isUpper;

        public DatabaseAdaptor(DatabaseMetaData dbMeta) throws SQLException {
            this._dbName = dbMeta.getDatabaseProductName().toLowerCase(Locale.ENGLISH);
            LOG.debug("Using database {}", this._dbName);
            this._isLower = dbMeta.storesLowerCaseIdentifiers();
            this._isUpper = dbMeta.storesUpperCaseIdentifiers();
        }

        public String convertIdentifier(String identifier) {
            if (this._isLower) {
                return identifier.toLowerCase(Locale.ENGLISH);
            }
            if (this._isUpper) {
                return identifier.toUpperCase(Locale.ENGLISH);
            }
            return identifier;
        }

        public String getDBName() {
            return this._dbName;
        }

        public String getBlobType() {
            if (JDBCSessionIdManager.this._blobType != null) {
                return JDBCSessionIdManager.this._blobType;
            }
            if (this._dbName.startsWith("postgres")) {
                return "bytea";
            }
            return "blob";
        }

        public String getLongType() {
            if (JDBCSessionIdManager.this._longType != null) {
                return JDBCSessionIdManager.this._longType;
            }
            if (this._dbName.startsWith("oracle")) {
                return "number(20)";
            }
            return "bigint";
        }

        public InputStream getBlobInputStream(ResultSet result, String columnName) throws SQLException {
            if (this._dbName.startsWith("postgres")) {
                byte[] bytes = result.getBytes(columnName);
                return new ByteArrayInputStream(bytes);
            }
            Blob blob = result.getBlob(columnName);
            return blob.getBinaryStream();
        }

        public String getRowIdColumnName() {
            if (this._dbName != null && this._dbName.startsWith("oracle")) {
                return "srowId";
            }
            return "rowId";
        }

        public boolean isEmptyStringNull() {
            return this._dbName.startsWith("oracle");
        }

        public PreparedStatement getLoadStatement(Connection connection, String rowId, String contextPath, String virtualHosts) throws SQLException {
            if ((contextPath == null || "".equals(contextPath)) && this.isEmptyStringNull()) {
                PreparedStatement statement = connection.prepareStatement("select * from " + JDBCSessionIdManager.this._sessionTable + " where sessionId = ? and contextPath is null and virtualHost = ?");
                statement.setString(1, rowId);
                statement.setString(2, virtualHosts);
                return statement;
            }
            PreparedStatement statement = connection.prepareStatement("select * from " + JDBCSessionIdManager.this._sessionTable + " where sessionId = ? and contextPath = ? and virtualHost = ?");
            statement.setString(1, rowId);
            statement.setString(2, contextPath);
            statement.setString(3, virtualHosts);
            return statement;
        }
    }
}

