/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.webapp.WebAppContext;

public class ContainerInitializer {
    protected ServletContainerInitializer _target;
    protected Class[] _interestedTypes;
    protected Set<String> _applicableTypeNames;
    protected Set<String> _annotatedTypeNames;

    public void setTarget(ServletContainerInitializer target) {
        this._target = target;
    }

    public ServletContainerInitializer getTarget() {
        return this._target;
    }

    public Class[] getInterestedTypes() {
        return this._interestedTypes;
    }

    public void setInterestedTypes(Class[] interestedTypes) {
        this._interestedTypes = interestedTypes;
    }

    public void addAnnotatedTypeName(String className) {
        if (this._annotatedTypeNames == null) {
            this._annotatedTypeNames = new HashSet<String>();
        }
        this._annotatedTypeNames.add(className);
    }

    public Set<String> getAnnotatedTypeNames() {
        return this._annotatedTypeNames;
    }

    public void addApplicableTypeName(String className) {
        if (this._applicableTypeNames == null) {
            this._applicableTypeNames = new HashSet<String>();
        }
        this._applicableTypeNames.add(className);
    }

    public Set<String> getApplicableTypeNames() {
        return this._applicableTypeNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callStartup(WebAppContext context) throws Exception {
        if (this._target != null) {
            HashSet classes = new HashSet();
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(context.getClassLoader());
            try {
                if (this._applicableTypeNames != null) {
                    for (String s : this._applicableTypeNames) {
                        classes.add(Loader.loadClass(context.getClass(), s));
                    }
                }
                this._target.onStartup(classes, context.getServletContext());
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }
}

