/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.servlet;

import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public abstract class WebSocketServlet
extends HttpServlet {
    private WebSocketServletFactory factory;

    public abstract void configure(WebSocketServletFactory var1);

    @Override
    public void destroy() {
        this.factory.cleanup();
    }

    @Override
    public void init() throws ServletException {
        try {
            WebSocketServletFactory baseFactory;
            Iterator<WebSocketServletFactory> factories;
            String max;
            String bs = this.getInitParameter("bufferSize");
            WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
            if (bs != null) {
                policy.setBufferSize(Integer.parseInt(bs));
            }
            if ((max = this.getInitParameter("maxIdleTime")) != null) {
                policy.setIdleTimeout(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("maxTextMessageSize")) != null) {
                policy.setMaxTextMessageSize(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("maxBinaryMessageSize")) != null) {
                policy.setMaxBinaryMessageSize(Integer.parseInt(max));
            }
            if ((factories = ServiceLoader.load(WebSocketServletFactory.class).iterator()).hasNext()) {
                baseFactory = factories.next();
            } else {
                Class<?> wssf = this.getServletContext().getClass().getClassLoader().loadClass("org.eclipse.jetty.websocket.server.WebSocketServerFactory");
                baseFactory = (WebSocketServletFactory)wssf.newInstance();
            }
            this.factory = baseFactory.createFactory(policy);
            this.configure(this.factory);
            this.factory.init();
        }
        catch (Exception x) {
            throw new ServletException(x);
        }
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.factory.isUpgradeRequest(request, response)) {
            if (this.factory.acceptWebSocket(request, response)) {
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.service(request, response);
    }
}

