/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.TimerScheduler;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.extensions.ExtensionStack;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;
import org.eclipse.jetty.websocket.server.ServletWebSocketRequest;
import org.eclipse.jetty.websocket.server.ServletWebSocketResponse;
import org.eclipse.jetty.websocket.server.UpgradeContext;
import org.eclipse.jetty.websocket.server.WebSocketHandshake;
import org.eclipse.jetty.websocket.server.WebSocketServerConnection;
import org.eclipse.jetty.websocket.server.handshake.HandshakeRFC6455;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class WebSocketServerFactory
extends ContainerLifeCycle
implements WebSocketCreator,
WebSocketServletFactory {
    private static final Logger LOG = Log.getLogger(WebSocketServerFactory.class);
    private static final ThreadLocal<UpgradeContext> ACTIVE_CONTEXT = new ThreadLocal();
    private final Map<Integer, WebSocketHandshake> handshakes = new HashMap<Integer, WebSocketHandshake>();
    private final Queue<WebSocketSession> sessions;
    private final Scheduler scheduler;
    private final String supportedVersions;
    private final WebSocketPolicy basePolicy;
    private final EventDriverFactory eventDriverFactory;
    private final WebSocketExtensionFactory extensionFactory;
    private WebSocketCreator creator;
    private List<Class<?>> registeredSocketClasses;

    public static UpgradeContext getActiveUpgradeContext() {
        return ACTIVE_CONTEXT.get();
    }

    protected static void setActiveUpgradeContext(UpgradeContext connection) {
        ACTIVE_CONTEXT.set(connection);
    }

    public WebSocketServerFactory() {
        this(WebSocketPolicy.newServerPolicy(), new MappedByteBufferPool());
    }

    public WebSocketServerFactory(WebSocketPolicy policy) {
        this(policy, new MappedByteBufferPool());
    }

    public WebSocketServerFactory(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this.handshakes.put(13, new HandshakeRFC6455());
        this.sessions = new ConcurrentLinkedQueue<WebSocketSession>();
        this.scheduler = new TimerScheduler();
        this.addBean(this.scheduler);
        this.addBean(bufferPool);
        this.registeredSocketClasses = new ArrayList();
        this.basePolicy = policy;
        this.eventDriverFactory = new EventDriverFactory(this.basePolicy);
        this.extensionFactory = new WebSocketExtensionFactory(this.basePolicy, bufferPool);
        this.creator = this;
        ArrayList<Integer> versions = new ArrayList<Integer>();
        for (int v : this.handshakes.keySet()) {
            versions.add(v);
        }
        Collections.sort(versions, Collections.reverseOrder());
        StringBuilder rv = new StringBuilder();
        Iterator i$ = versions.iterator();
        while (i$.hasNext()) {
            int v = (Integer)i$.next();
            if (rv.length() > 0) {
                rv.append(", ");
            }
            rv.append(v);
        }
        this.supportedVersions = rv.toString();
    }

    @Override
    public boolean acceptWebSocket(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletWebSocketRequest sockreq = new ServletWebSocketRequest(request);
        ServletWebSocketResponse sockresp = new ServletWebSocketResponse(response);
        WebSocketCreator creator = this.getCreator();
        UpgradeContext context = WebSocketServerFactory.getActiveUpgradeContext();
        if (context == null) {
            context = new UpgradeContext();
            WebSocketServerFactory.setActiveUpgradeContext(context);
        }
        context.setRequest(sockreq);
        context.setResponse(sockresp);
        Object websocketPojo = creator.createWebSocket(sockreq, sockresp);
        if (sockresp.isCommitted()) {
            return false;
        }
        if (websocketPojo == null) {
            response.sendError(503);
            return false;
        }
        EventDriver driver = this.eventDriverFactory.wrap(websocketPojo);
        return this.upgrade(sockreq, sockresp, driver);
    }

    @Override
    public void cleanup() {
        try {
            this.stop();
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }

    protected void closeAllConnections() {
        for (WebSocketSession session : this.sessions) {
            try {
                session.close();
            }
            catch (IOException e) {
                LOG.warn("CloseAllConnections Close failure", e);
            }
        }
        this.sessions.clear();
    }

    @Override
    public WebSocketServletFactory createFactory(WebSocketPolicy policy) {
        return new WebSocketServerFactory(policy);
    }

    @Override
    public Object createWebSocket(UpgradeRequest req, UpgradeResponse resp) {
        if (this.registeredSocketClasses.size() < 1) {
            throw new WebSocketException("No WebSockets have been registered with the factory.  Cannot use default implementation of WebSocketCreator.");
        }
        if (this.registeredSocketClasses.size() > 1) {
            LOG.warn("You have registered more than 1 websocket object, and are using the default WebSocketCreator! Using first registered websocket.", new Object[0]);
        }
        Class<?> firstClass = this.registeredSocketClasses.get(0);
        try {
            return firstClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new WebSocketException("Unable to create instance of " + firstClass, e);
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.closeAllConnections();
        super.doStop();
    }

    @Override
    public WebSocketCreator getCreator() {
        return this.creator;
    }

    @Override
    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.basePolicy;
    }

    @Override
    public void init() throws Exception {
        this.start();
    }

    @Override
    public boolean isUpgradeRequest(HttpServletRequest request, HttpServletResponse response) {
        String upgrade = request.getHeader("Upgrade");
        if (upgrade == null) {
            return false;
        }
        if (!"websocket".equalsIgnoreCase(upgrade)) {
            LOG.warn("Not a 'Upgrade: WebSocket' (was [Upgrade: " + upgrade + "])", new Object[0]);
            return false;
        }
        if (!"HTTP/1.1".equals(request.getProtocol())) {
            LOG.warn("Not a 'HTTP/1.1' request (was [" + request.getProtocol() + "])", new Object[0]);
            return false;
        }
        return true;
    }

    protected String[] parseProtocols(String protocol) {
        if (protocol == null) {
            return new String[]{null};
        }
        if ((protocol = protocol.trim()) == null || protocol.length() == 0) {
            return new String[]{null};
        }
        String[] passed = protocol.split("\\s*,\\s*");
        String[] protocols = new String[passed.length + 1];
        System.arraycopy(passed, 0, protocols, 0, passed.length);
        return protocols;
    }

    @Override
    public void register(Class<?> websocketPojo) {
        this.registeredSocketClasses.add(websocketPojo);
    }

    public boolean sessionClosed(WebSocketSession session) {
        return this.isRunning() && this.sessions.remove(session);
    }

    public boolean sessionOpened(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session Opened: {}", session);
        }
        if (!this.isRunning()) {
            LOG.warn("Factory is not running", new Object[0]);
            return false;
        }
        boolean ret = this.sessions.offer(session);
        session.open();
        return ret;
    }

    @Override
    public void setCreator(WebSocketCreator creator) {
        this.creator = creator;
    }

    public boolean upgrade(ServletWebSocketRequest request, ServletWebSocketResponse response, EventDriver driver) throws IOException {
        WebSocketHandshake handshaker;
        if (!"websocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
            throw new IllegalStateException("Not a 'WebSocket: Upgrade' request");
        }
        if (!"HTTP/1.1".equals(request.getHttpVersion())) {
            throw new IllegalStateException("Not a 'HTTP/1.1' request");
        }
        int version = request.getHeaderInt("Sec-WebSocket-Version");
        if (version < 0) {
            version = request.getHeaderInt("Sec-WebSocket-Draft");
        }
        if ((handshaker = this.handshakes.get(version)) == null) {
            LOG.warn("Unsupported Websocket version: " + version, new Object[0]);
            response.setHeader("Sec-WebSocket-Version", this.supportedVersions);
            response.sendError(400, "Unsupported websocket version specification");
            return false;
        }
        ExtensionStack extensionStack = new ExtensionStack(this.getExtensionFactory());
        extensionStack.negotiate(request.getExtensions());
        UpgradeContext context = WebSocketServerFactory.getActiveUpgradeContext();
        LogicalConnection connection = context.getConnection();
        if (connection == null) {
            HttpConnection http = HttpConnection.getCurrentConnection();
            EndPoint endp = http.getEndPoint();
            Executor executor = http.getConnector().getExecutor();
            ByteBufferPool bufferPool = http.getConnector().getByteBufferPool();
            WebSocketServerConnection wsConnection = new WebSocketServerConnection(endp, executor, this.scheduler, driver.getPolicy(), bufferPool, this);
            connection = wsConnection;
            extensionStack.configure(wsConnection.getParser());
            extensionStack.configure(wsConnection.getGenerator());
            LOG.debug("HttpConnection: {}", http);
            LOG.debug("AsyncWebSocketConnection: {}", connection);
        }
        WebSocketSession session = new WebSocketSession(request.getRequestURI(), driver, connection);
        session.setPolicy(this.getPolicy().clonePolicy());
        session.setNegotiatedSubprotocol(response.getAcceptedSubProtocol());
        session.setNegotiatedExtensions(extensionStack.getNegotiatedExtensions());
        connection.setSession(session);
        connection.setNextIncomingFrames(extensionStack);
        extensionStack.setNextIncoming(session);
        session.setOutgoingHandler(extensionStack);
        extensionStack.setNextOutgoing(connection);
        try {
            session.start();
        }
        catch (Exception e) {
            throw new IOException("Unable to start Session", e);
        }
        try {
            extensionStack.start();
        }
        catch (Exception e) {
            throw new IOException("Unable to start Extension Stack", e);
        }
        request.setServletAttribute("org.eclipse.jetty.server.HttpConnection.UPGRADE", connection);
        LOG.debug("Handshake Response: {}", handshaker);
        handshaker.doHandshakeResponse(request, response);
        LOG.debug("Websocket upgrade {} {} {} {}", request.getRequestURI(), version, response.getAcceptedSubProtocol(), connection);
        return true;
    }
}

