/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.extensions.compress.DeflateCompressionMethod;

public class FrameCompressionExtension
extends AbstractExtension {
    private DeflateCompressionMethod method;

    @Override
    public void incomingFrame(Frame frame) {
        if (frame.getType().isControl() || !frame.isRsv1()) {
            this.nextIncomingFrame(frame);
            return;
        }
        ByteBuffer data = frame.getPayload();
        this.method.decompress().input(data);
        while (!this.method.decompress().isDone()) {
            ByteBuffer uncompressed = this.method.decompress().process();
            WebSocketFrame out = new WebSocketFrame(frame).setPayload(uncompressed);
            if (!this.method.decompress().isDone()) {
                out.setFin(false);
            }
            out.setRsv1(false);
            this.nextIncomingFrame(out);
        }
    }

    @Override
    public boolean isRsv1User() {
        return true;
    }

    @Override
    public boolean isTextDataDecoder() {
        return true;
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback) {
        if (frame.getType().isControl()) {
            this.nextOutgoingFrame(frame, callback);
            return;
        }
        ByteBuffer data = frame.getPayload();
        this.method.compress().input(data);
        while (!this.method.compress().isDone()) {
            ByteBuffer buf = this.method.compress().process();
            WebSocketFrame out = new WebSocketFrame(frame).setPayload(buf);
            out.setRsv1(true);
            if (!this.method.compress().isDone()) {
                out.setFin(false);
                this.nextOutgoingFrame(frame, null);
                continue;
            }
            this.nextOutgoingFrame(out, callback);
        }
        this.method.compress().end();
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        super.setConfig(config);
        this.method = new DeflateCompressionMethod();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

