/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.CloseStatus;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.WebSocketConnection;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketRemoteEndpoint;
import org.eclipse.jetty.websocket.common.events.EventDriver;

@ManagedObject
public class WebSocketSession
extends ContainerLifeCycle
implements Session,
WebSocketConnection,
IncomingFrames {
    private static final Logger LOG = Log.getLogger(WebSocketSession.class);
    private final URI requestURI;
    private final EventDriver websocket;
    private final LogicalConnection connection;
    private ExtensionFactory extensionFactory;
    private boolean active = false;
    private long maximumMessageSize;
    private List<String> negotiatedExtensions = new ArrayList<String>();
    private String protocolVersion;
    private String negotiatedSubprotocol;
    private long timeout;
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private WebSocketRemoteEndpoint remote;
    private IncomingFrames incomingHandler;
    private OutgoingFrames outgoingHandler;
    private WebSocketPolicy policy;

    public WebSocketSession(URI requestURI, EventDriver websocket, LogicalConnection connection) {
        if (requestURI == null) {
            throw new RuntimeException("Request URI cannot be null");
        }
        this.requestURI = requestURI;
        this.websocket = websocket;
        this.connection = connection;
        this.outgoingHandler = connection;
        this.incomingHandler = websocket;
        MultiMap<String> params = new MultiMap<String>();
        String query = requestURI.getQuery();
        if (StringUtil.isNotBlank(query)) {
            UrlEncoded.decodeTo(query, params, "UTF-8");
        }
        for (String name : params.keySet()) {
            List<String> valueList = params.getValues(name);
            String[] valueArr = new String[valueList.size()];
            valueArr = valueList.toArray(valueArr);
            this.parameterMap.put(name, valueArr);
        }
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }

    @Override
    public void close(CloseStatus closeStatus) throws IOException {
        this.connection.close(closeStatus.getCode(), closeStatus.getPhrase());
    }

    @Override
    public void close(int statusCode, String reason) {
        this.connection.close(statusCode, reason);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        out.append(indent).append(" +- incomingHandler : ");
        if (this.incomingHandler instanceof Dumpable) {
            ((Dumpable)((Object)this.incomingHandler)).dump(out, indent + "    ");
        } else {
            out.append(this.incomingHandler.toString()).append('\n');
        }
        out.append(indent).append(" +- outgoingHandler : ");
        if (this.outgoingHandler instanceof Dumpable) {
            ((Dumpable)((Object)this.outgoingHandler)).dump(out, indent + "    ");
        } else {
            out.append(this.outgoingHandler.toString()).append('\n');
        }
    }

    public LogicalConnection getConnection() {
        return this.connection;
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    @ManagedAttribute(readonly=true)
    public IncomingFrames getIncomingHandler() {
        return this.incomingHandler;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    @Override
    public long getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    @Override
    public List<String> getNegotiatedExtensions() {
        return this.negotiatedExtensions;
    }

    @Override
    public String getNegotiatedSubprotocol() {
        return this.negotiatedSubprotocol;
    }

    @ManagedAttribute(readonly=true)
    public OutgoingFrames getOutgoingHandler() {
        return this.outgoingHandler;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public String getQueryString() {
        return this.getRequestURI().getQuery();
    }

    @Override
    public RemoteEndpoint getRemote() {
        if (!this.isOpen()) {
            throw new WebSocketException("Session has not been opened yet");
        }
        return this.remote;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remote.getInetSocketAddress();
    }

    @Override
    public URI getRequestURI() {
        return this.requestURI;
    }

    @Override
    public String getSubProtocol() {
        return this.getNegotiatedSubprotocol();
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void incomingError(WebSocketException e) {
        if (this.connection.getIOState().isInputClosed()) {
            return;
        }
        this.websocket.incomingError(e);
    }

    @Override
    public void incomingFrame(Frame frame) {
        if (this.connection.getIOState().isInputClosed()) {
            return;
        }
        this.incomingHandler.incomingFrame(frame);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isOpen() {
        return this.isActive();
    }

    @Override
    public boolean isSecure() {
        return this.getRequestURI().getScheme().equalsIgnoreCase("wss");
    }

    public void open() {
        if (this.isOpen()) {
            throw new WebSocketException("Cannot Open WebSocketSession, Already open");
        }
        this.remote = new WebSocketRemoteEndpoint(this.connection, this.outgoingHandler);
        this.active = true;
        this.websocket.setSession(this);
        this.websocket.onConnect();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", this.dump());
        }
    }

    @Override
    public void ping(ByteBuffer buf) throws IOException {
        this.remote.sendPing(buf);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setExtensionFactory(ExtensionFactory extensionFactory) {
        this.extensionFactory = extensionFactory;
    }

    @Override
    public void setMaximumMessageSize(long length) {
        this.maximumMessageSize = length;
    }

    public void setNegotiatedExtensions(List<String> negotiatedExtensions) {
        this.negotiatedExtensions.clear();
        this.negotiatedExtensions.addAll(negotiatedExtensions);
    }

    public void setNegotiatedSubprotocol(String negotiatedSubprotocol) {
        this.negotiatedSubprotocol = negotiatedSubprotocol;
    }

    public void setOutgoingHandler(OutgoingFrames outgoing) {
        this.outgoingHandler = outgoing;
    }

    public void setPolicy(WebSocketPolicy policy) {
        this.policy = policy;
    }

    @Override
    public void setTimeout(long seconds) {
        this.timeout = seconds;
    }

    @Override
    public SuspendToken suspend() {
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketSession[");
        builder.append("websocket=").append(this.websocket);
        builder.append(",connection=").append(this.connection);
        builder.append(",remote=").append(this.remote);
        builder.append(",incoming=").append(this.incomingHandler);
        builder.append(",outgoing=").append(this.outgoingHandler);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Future<Void> write(byte[] buf, int offset, int len) {
        return this.remote.sendBytesByFuture(ByteBuffer.wrap(buf, offset, len));
    }

    @Override
    public Future<Void> write(ByteBuffer buffer) {
        return this.remote.sendBytesByFuture(buffer);
    }

    @Override
    public Future<Void> write(String message) {
        return this.remote.sendStringByFuture(message);
    }
}

