/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.runner;

import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.StatisticsServlet;
import org.eclipse.jetty.util.RolloverFileOutputStream;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Runner {
    private static final Logger LOG = LoggerFactory.getLogger(Runner.class);
    public static final String[] PLUS_CONFIGURATION_CLASSES = new String[]{WebInfConfiguration.class.getCanonicalName(), WebXmlConfiguration.class.getCanonicalName(), MetaInfConfiguration.class.getCanonicalName(), FragmentConfiguration.class.getCanonicalName(), EnvConfiguration.class.getCanonicalName(), PlusConfiguration.class.getCanonicalName(), AnnotationConfiguration.class.getCanonicalName(), JettyWebXmlConfiguration.class.getCanonicalName()};
    public static final String CONTAINER_INCLUDE_JAR_PATTERN = ".*/jetty-runner-[^/]*\\.jar$";
    public static final String DEFAULT_CONTEXT_PATH = "/";
    public static final int DEFAULT_PORT = 8080;
    protected Server _server;
    protected URLClassLoader _classLoader;
    protected Classpath _classpath = new Classpath();
    protected ContextHandlerCollection _contexts;
    protected String _logFile;
    protected ArrayList<String> _configFiles;
    protected boolean _enableStats = false;
    protected String _statsPropFile;

    public void usage(String error) {
        if (error != null) {
            System.err.println("ERROR: " + error);
        }
        System.err.println("Usage: java [-Djetty.home=dir] -jar jetty-runner.jar [--help|--version] [ server opts] [[ context opts] context ...] ");
        System.err.println("Server opts:");
        System.err.println(" --version                           - display version and exit");
        System.err.println(" --log file                          - request log filename (with optional 'yyyy_mm_dd' wildcard");
        System.err.println(" --out file                          - info/warn/debug log filename (with optional 'yyyy_mm_dd' wildcard");
        System.err.println(" --host name|ip                      - interface to listen on (default is all interfaces)");
        System.err.println(" --port n                            - port to listen on (default 8080)");
        System.err.println(" --stop-port n                       - port to listen for stop command (or -DSTOP.PORT=n)");
        System.err.println(" --stop-key n                        - security string for stop command (required if --stop-port is present) (or -DSTOP.KEY=n)");
        System.err.println(" [--jar file]*n                      - each tuple specifies an extra jar to be added to the classloader");
        System.err.println(" [--lib dir]*n                       - each tuple specifies an extra directory of jars to be added to the classloader");
        System.err.println(" [--classes dir]*n                   - each tuple specifies an extra directory of classes to be added to the classloader");
        System.err.println(" --stats [unsecure|realm.properties] - enable stats gathering servlet context");
        System.err.println(" [--config file]*n                   - each tuple specifies the name of a jetty xml config file to apply (in the order defined)");
        System.err.println("Context opts:");
        System.err.println(" [[--path /path] context]*n          - WAR file, web app dir or context xml file, optionally with a context path");
        System.exit(1);
    }

    public void version() {
        System.err.println("org.eclipse.jetty.runner.Runner: " + Server.getVersion());
        System.exit(1);
    }

    public void configure(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if ("--lib".equals(args[i])) {
                try (Resource lib = Resource.newResource(args[++i]);){
                    if (!lib.exists() || !lib.isDirectory()) {
                        this.usage("No such lib directory " + lib);
                    }
                    this._classpath.addJars(lib);
                    continue;
                }
            }
            if ("--jar".equals(args[i])) {
                try (Resource jar = Resource.newResource(args[++i]);){
                    if (!jar.exists() || jar.isDirectory()) {
                        this.usage("No such jar " + jar);
                    }
                    this._classpath.addPath(jar);
                    continue;
                }
            }
            if ("--classes".equals(args[i])) {
                try (Resource classes = Resource.newResource(args[++i]);){
                    if (!classes.exists() || !classes.isDirectory()) {
                        this.usage("No such classes directory " + classes);
                    }
                    this._classpath.addPath(classes);
                    continue;
                }
            }
            if (!args[i].startsWith("--")) continue;
            ++i;
        }
        this.initClassLoader();
        LOG.info("Runner");
        LOG.debug("Runner classpath {}", (Object)this._classpath);
        Object contextPath = DEFAULT_CONTEXT_PATH;
        boolean contextPathSet = false;
        int port = 8080;
        String host = null;
        int stopPort = Integer.getInteger("STOP.PORT", 0);
        Object stopKey = System.getProperty("STOP.KEY", null);
        boolean runnerServerInitialized = false;
        block59: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "--port": {
                    port = Integer.parseInt(args[++i]);
                    continue block59;
                }
                case "--host": {
                    host = args[++i];
                    continue block59;
                }
                case "--stop-port": {
                    stopPort = Integer.parseInt(args[++i]);
                    continue block59;
                }
                case "--stop-key": {
                    stopKey = args[++i];
                    continue block59;
                }
                case "--log": {
                    this._logFile = args[++i];
                    continue block59;
                }
                case "--out": {
                    String outFile = args[++i];
                    PrintStream out = new PrintStream(new RolloverFileOutputStream(outFile, true, -1));
                    LOG.info("Redirecting stderr/stdout to {}", (Object)outFile);
                    System.setErr(out);
                    System.setOut(out);
                    continue block59;
                }
                case "--path": {
                    contextPath = args[++i];
                    contextPathSet = true;
                    continue block59;
                }
                case "--config": {
                    if (this._configFiles == null) {
                        this._configFiles = new ArrayList();
                    }
                    this._configFiles.add(args[++i]);
                    continue block59;
                }
                case "--lib": {
                    ++i;
                    continue block59;
                }
                case "--jar": {
                    ++i;
                    continue block59;
                }
                case "--classes": {
                    ++i;
                    continue block59;
                }
                case "--stats": {
                    this._enableStats = true;
                    this._statsPropFile = args[++i];
                    this._statsPropFile = "unsecure".equalsIgnoreCase(this._statsPropFile) ? null : this._statsPropFile;
                    continue block59;
                }
                default: {
                    if (args[i].startsWith("-D")) {
                        String[] sysProps = args[i].substring(2).split("=", 2);
                        if ("STOP.KEY".equals(sysProps[0])) {
                            stopKey = sysProps[1];
                            continue block59;
                        }
                        if ("STOP.PORT".equals(sysProps[0])) {
                            stopPort = Integer.parseInt((String)sysProps[1]);
                            continue block59;
                        }
                    }
                    if (!runnerServerInitialized) {
                        Connector[] connectors;
                        HandlerCollection handlers;
                        if (this._server == null) {
                            this._server = new Server();
                        }
                        if (this._configFiles != null) {
                            for (String cfg : this._configFiles) {
                                try (Resource resource = Resource.newResource(cfg);){
                                    XmlConfiguration xmlConfiguration = new XmlConfiguration(resource);
                                    xmlConfiguration.configure(this._server);
                                }
                            }
                        }
                        if ((handlers = this._server.getChildHandlerByClass(HandlerCollection.class)) == null) {
                            handlers = new HandlerList();
                            this._server.setHandler(handlers);
                        }
                        this._contexts = handlers.getChildHandlerByClass(ContextHandlerCollection.class);
                        if (this._contexts == null) {
                            this._contexts = new ContextHandlerCollection();
                            this.prependHandler(this._contexts, handlers);
                        }
                        if (this._enableStats && handlers.getChildHandlerByClass(StatisticsHandler.class) == null) {
                            StatisticsHandler statsHandler = new StatisticsHandler();
                            Handler oldHandler = this._server.getHandler();
                            statsHandler.setHandler(oldHandler);
                            this._server.setHandler(statsHandler);
                            ServletContextHandler statsContext = new ServletContextHandler(this._contexts, "/stats");
                            statsContext.addServlet(new ServletHolder(new StatisticsServlet()), DEFAULT_CONTEXT_PATH);
                            statsContext.setSessionHandler(new SessionHandler());
                            if (this._statsPropFile != null) {
                                HashLoginService loginService = new HashLoginService("StatsRealm", this._statsPropFile);
                                Constraint constraint = new Constraint();
                                constraint.setName("Admin Only");
                                constraint.setRoles(new String[]{"admin"});
                                constraint.setAuthenticate(true);
                                ConstraintMapping cm = new ConstraintMapping();
                                cm.setConstraint(constraint);
                                cm.setPathSpec("/*");
                                ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
                                securityHandler.setLoginService(loginService);
                                securityHandler.setConstraintMappings(Collections.singletonList(cm));
                                securityHandler.setAuthenticator(new BasicAuthenticator());
                                statsContext.setSecurityHandler(securityHandler);
                            }
                        }
                        if (handlers.getChildHandlerByClass(DefaultHandler.class) == null) {
                            handlers.addHandler(new DefaultHandler());
                        }
                        if ((connectors = this._server.getConnectors()) == null || connectors.length == 0) {
                            Connector[] connector = new ServerConnector(this._server);
                            connector.setPort(port);
                            if (host != null) {
                                connector.setHost(host);
                            }
                            this._server.addConnector((Connector)connector);
                            if (this._enableStats) {
                                connector.addBean(new ConnectionStatistics());
                            }
                        } else if (this._enableStats) {
                            for (Connector connector : connectors) {
                                ((AbstractConnector)connector).addBean(new ConnectionStatistics());
                            }
                        }
                        runnerServerInitialized = true;
                    }
                    try (Resource ctx = Resource.newResource(args[i]);){
                        if (!ctx.exists()) {
                            this.usage("Context '" + ctx + "' does not exist");
                        }
                        if (contextPathSet && !((String)contextPath).startsWith(DEFAULT_CONTEXT_PATH)) {
                            contextPath = DEFAULT_CONTEXT_PATH + (String)contextPath;
                        }
                        if (!ctx.isDirectory() && ctx.toString().toLowerCase(Locale.ENGLISH).endsWith(".xml")) {
                            WebAppContext wac;
                            XmlConfiguration xmlConfiguration = new XmlConfiguration(ctx);
                            xmlConfiguration.getIdMap().put("Server", this._server);
                            ContextHandler handler = (ContextHandler)xmlConfiguration.configure();
                            if (contextPathSet) {
                                handler.setContextPath((String)contextPath);
                            }
                            this._contexts.addHandler(handler);
                            Object containerIncludeJarPattern = (String)handler.getAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern");
                            if (containerIncludeJarPattern == null) {
                                containerIncludeJarPattern = CONTAINER_INCLUDE_JAR_PATTERN;
                            } else if (!((String)containerIncludeJarPattern).contains(CONTAINER_INCLUDE_JAR_PATTERN)) {
                                containerIncludeJarPattern = (String)containerIncludeJarPattern + (StringUtil.isBlank((String)containerIncludeJarPattern) ? "" : "|") + CONTAINER_INCLUDE_JAR_PATTERN;
                            }
                            handler.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", containerIncludeJarPattern);
                            if (handler instanceof WebAppContext && ((wac = (WebAppContext)handler).getConfigurationClasses() == null || wac.getConfigurationClasses().length == 0)) {
                                wac.setConfigurationClasses(PLUS_CONFIGURATION_CLASSES);
                            }
                        } else {
                            WebAppContext webapp = new WebAppContext((HandlerContainer)this._contexts, ctx.toString(), (String)contextPath);
                            webapp.setConfigurationClasses(PLUS_CONFIGURATION_CLASSES);
                            webapp.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", CONTAINER_INCLUDE_JAR_PATTERN);
                        }
                    }
                    contextPathSet = false;
                    contextPath = DEFAULT_CONTEXT_PATH;
                }
            }
        }
        if (this._server == null) {
            this.usage("No Contexts defined");
        }
        this._server.setStopAtShutdown(true);
        switch ((stopPort > 0 ? 1 : 0) + (stopKey != null ? 2 : 0)) {
            case 1: {
                this.usage("Must specify --stop-key when --stop-port is specified");
                break;
            }
            case 2: {
                this.usage("Must specify --stop-port when --stop-key is specified");
                break;
            }
            case 3: {
                ShutdownMonitor monitor = ShutdownMonitor.getInstance();
                monitor.setPort(stopPort);
                monitor.setKey((String)stopKey);
                monitor.setExitVm(true);
                break;
            }
        }
        if (this._logFile != null) {
            CustomRequestLog requestLog = new CustomRequestLog(this._logFile);
            this._server.setRequestLog(requestLog);
        }
    }

    protected void prependHandler(Handler handler, HandlerCollection handlers) {
        if (handler == null || handlers == null) {
            return;
        }
        Handler[] existing = handlers.getChildHandlers();
        Handler[] children = new Handler[existing.length + 1];
        children[0] = handler;
        System.arraycopy(existing, 0, children, 1, existing.length);
        handlers.setHandlers(children);
    }

    public void run() throws Exception {
        this._server.start();
        this._server.join();
    }

    private URL toURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void initClassLoader() {
        URL[] paths = (URL[])Arrays.stream(this._classpath.asArray()).map(this::toURL).toArray(URL[]::new);
        if (this._classLoader == null && paths.length > 0) {
            ClassLoader context = Thread.currentThread().getContextClassLoader();
            this._classLoader = context == null ? new URLClassLoader(paths) : new URLClassLoader(paths, context);
            Thread.currentThread().setContextClassLoader(this._classLoader);
        }
    }

    public static void main(String[] args) {
        System.err.println("WARNING: jetty-runner is deprecated.");
        System.err.println("         See Jetty Documentation for startup options");
        System.err.println("         https://www.eclipse.org/jetty/documentation/");
        Runner runner = new Runner();
        try {
            if (args.length > 0 && args[0].equalsIgnoreCase("--help")) {
                runner.usage(null);
            } else if (args.length > 0 && args[0].equalsIgnoreCase("--version")) {
                runner.version();
            } else {
                runner.configure(args);
                runner.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            runner.usage(null);
        }
    }

    public class Classpath {
        private List<URI> _classpath = new ArrayList<URI>();

        public void addJars(Resource lib) throws IOException {
            if (lib == null || !lib.exists()) {
                throw new IllegalStateException("No such lib: " + lib);
            }
            String[] list = lib.list();
            if (list == null) {
                return;
            }
            for (String path : list) {
                if (".".equals(path) || "..".equals(path)) continue;
                try (Resource item = lib.addPath(path);){
                    if (item.isDirectory()) {
                        this.addJars(item);
                        continue;
                    }
                    String lowerCasePath = path.toLowerCase(Locale.ENGLISH);
                    if (!lowerCasePath.endsWith(".jar") && !lowerCasePath.endsWith(".zip")) continue;
                    this._classpath.add(item.getURI());
                }
            }
        }

        public void addPath(Resource path) {
            if (path == null || !path.exists()) {
                throw new IllegalStateException("No such path: " + path);
            }
            this._classpath.add(path.getURI());
        }

        public URI[] asArray() {
            return this._classpath.toArray(new URI[0]);
        }
    }
}

