/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jetty.plus.annotation.Injection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectionCollection {
    private static final Logger LOG = LoggerFactory.getLogger(InjectionCollection.class);
    public static final String INJECTION_COLLECTION = "org.eclipse.jetty.injectionCollection";
    private final ConcurrentMap<String, Set<Injection>> _injectionMap = new ConcurrentHashMap<String, Set<Injection>>();

    public void add(Injection injection) {
        Set tmp;
        if (injection == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring null Injection");
            }
            return;
        }
        String name = injection.getTargetClass().getName();
        Set<Injection> injections = (CopyOnWriteArraySet<Injection>)this._injectionMap.get(name);
        if (injections == null && (tmp = (Set)this._injectionMap.putIfAbsent(name, injections = new CopyOnWriteArraySet<Injection>())) != null) {
            injections = tmp;
        }
        boolean added = injections.add(injection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding injection for class={} on {} added={}", name, injection.getTarget().getName(), added);
        }
    }

    public Set<Injection> getInjections(String className) {
        if (className == null) {
            return null;
        }
        return (Set)this._injectionMap.get(className);
    }

    public Injection getInjection(String jndiName, Class<?> clazz, Field field) {
        if (field == null || clazz == null) {
            return null;
        }
        Set<Injection> injections = this.getInjections(clazz.getName());
        if (injections == null) {
            return null;
        }
        Iterator<Injection> itor = injections.iterator();
        Injection injection = null;
        while (itor.hasNext() && injection == null) {
            Injection i2 = itor.next();
            if (!i2.isField() || !field.getName().equals(i2.getTarget().getName())) continue;
            injection = i2;
        }
        return injection;
    }

    public Injection getInjection(String jndiName, Class<?> clazz, Method method, Class<?> paramClass) {
        if (clazz == null || method == null || paramClass == null) {
            return null;
        }
        Set<Injection> injections = this.getInjections(clazz.getName());
        if (injections == null) {
            return null;
        }
        Iterator<Injection> itor = injections.iterator();
        Injection injection = null;
        while (itor.hasNext() && injection == null) {
            Injection i2 = itor.next();
            if (!i2.isMethod() || !i2.getTarget().getName().equals(method.getName()) || !paramClass.equals(i2.getParamClass())) continue;
            injection = i2;
        }
        return injection;
    }

    public void inject(Object injectable) {
        if (injectable == null) {
            return;
        }
        for (Class<?> clazz = injectable.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Set injections = (Set)this._injectionMap.get(clazz.getName());
            if (injections == null) continue;
            for (Injection i2 : injections) {
                i2.inject(injectable);
            }
        }
    }
}

