/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread.strategy;

import java.io.Closeable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.TryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="eat what you kill execution strategy")
public class EatWhatYouKill
extends ContainerLifeCycle
implements ExecutionStrategy,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(EatWhatYouKill.class);
    private final AutoLock _lock = new AutoLock();
    private final LongAdder _pcMode = new LongAdder();
    private final LongAdder _picMode = new LongAdder();
    private final LongAdder _pecMode = new LongAdder();
    private final LongAdder _epcMode = new LongAdder();
    private final ExecutionStrategy.Producer _producer;
    private final Executor _executor;
    private final TryExecutor _tryExecutor;
    private State _state = State.IDLE;
    private boolean _pending;

    public EatWhatYouKill(ExecutionStrategy.Producer producer, Executor executor) {
        this._producer = producer;
        this._executor = executor;
        this._tryExecutor = TryExecutor.asTryExecutor(executor);
        this.addBean(this._producer);
        this.addBean(this._tryExecutor);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} created", (Object)this);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void dispatch() {
        execute = false;
        l = this._lock.lock();
        try {
            switch (1.$SwitchMap$org$eclipse$jetty$util$thread$strategy$EatWhatYouKill$State[this._state.ordinal()]) {
                case 1: {
                    if (this._pending) ** break;
                    this._pending = true;
                    execute = true;
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 2: {
                    this._state = State.REPRODUCING;
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                ** default:
lbl16:
                // 1 sources

                break;
            }
        }
        finally {
            if (l != null) {
                l.close();
            }
        }
        if (EatWhatYouKill.LOG.isDebugEnabled()) {
            EatWhatYouKill.LOG.debug("{} dispatch {}", (Object)this, (Object)execute);
        }
        if (execute) {
            this._executor.execute(this);
        }
    }

    @Override
    public void run() {
        this.tryProduce(true);
    }

    @Override
    public void produce() {
        this.tryProduce(false);
    }

    /*
     * Unable to fully structure code
     */
    private void tryProduce(boolean wasPending) {
        if (EatWhatYouKill.LOG.isDebugEnabled()) {
            EatWhatYouKill.LOG.debug("{} tryProduce {}", (Object)this, (Object)wasPending);
        }
        l = this._lock.lock();
        try {
            if (wasPending) {
                this._pending = false;
            }
            switch (1.$SwitchMap$org$eclipse$jetty$util$thread$strategy$EatWhatYouKill$State[this._state.ordinal()]) {
                case 1: {
                    this._state = State.PRODUCING;
                    ** break;
lbl11:
                    // 1 sources

                    break;
                }
                case 2: {
                    this._state = State.REPRODUCING;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        finally {
            if (l != null) {
                l.close();
            }
        }
        nonBlocking = Invocable.isNonBlockingInvocation();
        while (this.isRunning()) {
            try {
                if (this.doProduce(nonBlocking)) continue;
                return;
            }
            catch (Throwable th) {
                EatWhatYouKill.LOG.warn("Unable to produce", th);
            }
        }
    }

    private boolean doProduce(boolean nonBlocking) {
        AutoLock l;
        Mode mode;
        Runnable task = this.produceTask();
        if (task == null) {
            try (AutoLock l2 = this._lock.lock();){
                switch (this._state) {
                    case PRODUCING: {
                        this._state = State.IDLE;
                        boolean bl = false;
                        return bl;
                    }
                    case REPRODUCING: {
                        this._state = State.PRODUCING;
                        boolean bl = true;
                        return bl;
                    }
                }
                throw new IllegalStateException(this.toStringLocked());
            }
        }
        if (nonBlocking) {
            switch (Invocable.getInvocationType(task)) {
                case NON_BLOCKING: {
                    mode = Mode.PRODUCE_CONSUME;
                    break;
                }
                case EITHER: {
                    mode = Mode.PRODUCE_INVOKE_CONSUME;
                    break;
                }
                default: {
                    mode = Mode.PRODUCE_EXECUTE_CONSUME;
                    break;
                }
            }
        } else {
            switch (Invocable.getInvocationType(task)) {
                case NON_BLOCKING: {
                    mode = Mode.PRODUCE_CONSUME;
                    break;
                }
                case BLOCKING: {
                    l = this._lock.lock();
                    try {
                        if (this._pending) {
                            this._state = State.IDLE;
                            mode = Mode.EXECUTE_PRODUCE_CONSUME;
                            break;
                        }
                        if (this._tryExecutor.tryExecute(this)) {
                            this._pending = true;
                            this._state = State.IDLE;
                            mode = Mode.EXECUTE_PRODUCE_CONSUME;
                            break;
                        }
                        mode = Mode.PRODUCE_EXECUTE_CONSUME;
                        break;
                    }
                    finally {
                        if (l != null) {
                            l.close();
                        }
                    }
                }
                case EITHER: {
                    l = this._lock.lock();
                    try {
                        if (this._pending) {
                            this._state = State.IDLE;
                            mode = Mode.EXECUTE_PRODUCE_CONSUME;
                            break;
                        }
                        if (this._tryExecutor.tryExecute(this)) {
                            this._pending = true;
                            this._state = State.IDLE;
                            mode = Mode.EXECUTE_PRODUCE_CONSUME;
                            break;
                        }
                        mode = Mode.PRODUCE_INVOKE_CONSUME;
                        break;
                    }
                    finally {
                        if (l != null) {
                            l.close();
                        }
                    }
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} m={} t={}/{}", new Object[]{this, mode, task, Invocable.getInvocationType(task)});
        }
        switch (mode) {
            case PRODUCE_CONSUME: {
                this._pcMode.increment();
                this.runTask(task);
                return true;
            }
            case PRODUCE_INVOKE_CONSUME: {
                this._picMode.increment();
                this.invokeTask(task);
                return true;
            }
            case PRODUCE_EXECUTE_CONSUME: {
                this._pecMode.increment();
                this.execute(task);
                return true;
            }
            case EXECUTE_PRODUCE_CONSUME: {
                this._epcMode.increment();
                this.runTask(task);
                l = this._lock.lock();
                try {
                    if (this._state == State.IDLE) {
                        this._state = State.PRODUCING;
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    if (l != null) {
                        l.close();
                    }
                }
                return false;
            }
        }
        throw new IllegalStateException(this.toString());
    }

    private void runTask(Runnable task) {
        try {
            task.run();
        }
        catch (Throwable x) {
            LOG.warn("Task run failed", x);
        }
    }

    private void invokeTask(Runnable task) {
        try {
            Invocable.invokeNonBlocking(task);
        }
        catch (Throwable x) {
            LOG.warn("Task invoke failed", x);
        }
    }

    private Runnable produceTask() {
        try {
            return this._producer.produce();
        }
        catch (Throwable e) {
            LOG.warn("Task produce failed", e);
            return null;
        }
    }

    private void execute(Runnable task) {
        block6: {
            try {
                this._executor.execute(task);
            }
            catch (RejectedExecutionException e) {
                if (this.isRunning()) {
                    LOG.warn("Execute failed", e);
                } else {
                    LOG.trace("IGNORED", e);
                }
                if (!(task instanceof Closeable)) break block6;
                try {
                    ((Closeable)((Object)task)).close();
                }
                catch (Throwable e2) {
                    LOG.trace("IGNORED", e2);
                }
            }
        }
    }

    @ManagedAttribute(value="number of tasks consumed with PC mode", readonly=true)
    public long getPCTasksConsumed() {
        return this._pcMode.longValue();
    }

    @ManagedAttribute(value="number of tasks executed with PIC mode", readonly=true)
    public long getPICTasksExecuted() {
        return this._picMode.longValue();
    }

    @ManagedAttribute(value="number of tasks executed with PEC mode", readonly=true)
    public long getPECTasksExecuted() {
        return this._pecMode.longValue();
    }

    @ManagedAttribute(value="number of tasks consumed with EPC mode", readonly=true)
    public long getEPCTasksConsumed() {
        return this._epcMode.longValue();
    }

    @ManagedAttribute(value="whether this execution strategy is idle", readonly=true)
    public boolean isIdle() {
        try (AutoLock l = this._lock.lock();){
            boolean bl = this._state == State.IDLE;
            return bl;
        }
    }

    @ManagedOperation(value="resets the task counts", impact="ACTION")
    public void reset() {
        this._pcMode.reset();
        this._epcMode.reset();
        this._pecMode.reset();
        this._picMode.reset();
    }

    @Override
    public String toString() {
        try (AutoLock l = this._lock.lock();){
            String string = this.toStringLocked();
            return string;
        }
    }

    public String toStringLocked() {
        StringBuilder builder = new StringBuilder();
        this.getString(builder);
        this.getState(builder);
        return builder.toString();
    }

    private void getString(StringBuilder builder) {
        builder.append(this.getClass().getSimpleName());
        builder.append('@');
        builder.append(Integer.toHexString(this.hashCode()));
        builder.append('/');
        builder.append(this._producer);
        builder.append('/');
    }

    private void getState(StringBuilder builder) {
        builder.append((Object)this._state);
        builder.append("/p=");
        builder.append(this._pending);
        builder.append('/');
        builder.append(this._tryExecutor);
        builder.append("[pc=");
        builder.append(this.getPCTasksConsumed());
        builder.append(",pic=");
        builder.append(this.getPICTasksExecuted());
        builder.append(",pec=");
        builder.append(this.getPECTasksExecuted());
        builder.append(",epc=");
        builder.append(this.getEPCTasksConsumed());
        builder.append("]");
        builder.append("@");
        builder.append(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now()));
    }

    private static enum Mode {
        PRODUCE_CONSUME,
        PRODUCE_INVOKE_CONSUME,
        PRODUCE_EXECUTE_CONSUME,
        EXECUTE_PRODUCE_CONSUME;

    }

    private static enum State {
        IDLE,
        PRODUCING,
        REPRODUCING;

    }
}

