/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.util.function.Function;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.execution.ExtensionValuesStore;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="5.0")
public class NamespaceAwareStore
implements ExtensionContext.Store {
    private final ExtensionValuesStore valuesStore;
    private final ExtensionContext.Namespace namespace;

    public NamespaceAwareStore(ExtensionValuesStore valuesStore, ExtensionContext.Namespace namespace) {
        this.valuesStore = valuesStore;
        this.namespace = namespace;
    }

    @Override
    public Object get(Object key) {
        Preconditions.notNull(key, "key must not be null");
        return this.valuesStore.get(this.namespace, key);
    }

    public <T> T get(Object key, Class<T> requiredType) {
        Preconditions.notNull(key, "key must not be null");
        Preconditions.notNull(requiredType, "requiredType must not be null");
        return this.valuesStore.get(this.namespace, key, requiredType);
    }

    @Override
    public <K, V> Object getOrComputeIfAbsent(K key, Function<K, V> defaultCreator) {
        Preconditions.notNull(key, "key must not be null");
        Preconditions.notNull(defaultCreator, "defaultCreator function must not be null");
        return this.valuesStore.getOrComputeIfAbsent(this.namespace, key, defaultCreator);
    }

    @Override
    public <K, V> V getOrComputeIfAbsent(K key, Function<K, V> defaultCreator, Class<V> requiredType) {
        Preconditions.notNull(key, "key must not be null");
        Preconditions.notNull(defaultCreator, "defaultCreator function must not be null");
        Preconditions.notNull(requiredType, "requiredType must not be null");
        return this.valuesStore.getOrComputeIfAbsent(this.namespace, key, defaultCreator, requiredType);
    }

    @Override
    public void put(Object key, Object value) {
        Preconditions.notNull(key, "key must not be null");
        this.valuesStore.put(this.namespace, key, value);
    }

    @Override
    public Object remove(Object key) {
        Preconditions.notNull(key, "key must not be null");
        return this.valuesStore.remove(this.namespace, key);
    }

    public <T> T remove(Object key, Class<T> requiredType) {
        Preconditions.notNull(key, "key must not be null");
        Preconditions.notNull(requiredType, "requiredType must not be null");
        return this.valuesStore.remove(this.namespace, key, requiredType);
    }
}

