/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.util.messages;

import java.io.Closeable;
import java.lang.invoke.MethodHandle;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.util.messages.AbstractMessageSink;
import org.eclipse.jetty.websocket.util.messages.MessageSink;

public abstract class DispatchedMessageSink
extends AbstractMessageSink {
    private CompletableFuture<Void> dispatchComplete;
    private MessageSink typeSink;

    public DispatchedMessageSink(CoreSession session, MethodHandle methodHandle) {
        super(session, methodHandle);
    }

    public abstract MessageSink newSink(Frame var1);

    @Override
    public void accept(Frame frame, Callback callback) {
        if (this.typeSink == null) {
            this.typeSink = this.newSink(frame);
            this.dispatchComplete = new CompletableFuture();
            new Thread(() -> {
                try {
                    this.methodHandle.invoke(this.typeSink);
                    if (this.typeSink instanceof Closeable) {
                        IO.close((Closeable)((Object)this.typeSink));
                    }
                    this.dispatchComplete.complete(null);
                }
                catch (Throwable throwable) {
                    if (this.typeSink instanceof Closeable) {
                        IO.close((Closeable)((Object)this.typeSink));
                    }
                    this.dispatchComplete.completeExceptionally(throwable);
                }
            }).start();
        }
        Callback frameCallback = callback;
        if (frame.isFin()) {
            Callback.Completable completableCallback = new Callback.Completable();
            frameCallback = completableCallback;
            CompletableFuture.allOf(this.dispatchComplete, completableCallback).whenComplete((aVoid, throwable) -> {
                this.typeSink = null;
                this.dispatchComplete = null;
                if (throwable != null) {
                    callback.failed((Throwable)throwable);
                } else {
                    callback.succeeded();
                }
            });
        }
        this.typeSink.accept(frame, frameCallback);
    }
}

