/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.util.messages;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.exception.MessageTooLargeException;
import org.eclipse.jetty.websocket.util.InvalidSignatureException;
import org.eclipse.jetty.websocket.util.messages.AbstractMessageSink;

public class ByteArrayMessageSink
extends AbstractMessageSink {
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private static final int BUFFER_SIZE = 65535;
    private ByteArrayOutputStream out;
    private int size;

    public ByteArrayMessageSink(CoreSession session, MethodHandle methodHandle) {
        super(session, methodHandle);
        MethodType onMessageType = MethodType.methodType(Void.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        if (methodHandle.type().changeReturnType(Void.TYPE) != onMessageType.changeReturnType(Void.TYPE)) {
            throw InvalidSignatureException.build(onMessageType, methodHandle.type());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Frame frame, Callback callback) {
        try {
            this.size += frame.getPayloadLength();
            long maxBinaryMessageSize = this.session.getMaxBinaryMessageSize();
            if (maxBinaryMessageSize > 0L && (long)this.size > maxBinaryMessageSize) {
                throw new MessageTooLargeException(String.format("Binary message too large: (actual) %,d > (configured max binary message size) %,d", this.size, maxBinaryMessageSize));
            }
            if (frame.isFin() && this.out == null) {
                if (frame.hasPayload()) {
                    byte[] buf = BufferUtil.toArray(frame.getPayload());
                    this.methodHandle.invoke(buf, 0, buf.length);
                } else {
                    this.methodHandle.invoke(EMPTY_BUFFER, 0, 0);
                }
                callback.succeeded();
                return;
            }
            this.aggregatePayload(frame);
            if (frame.isFin()) {
                byte[] buf = this.out.toByteArray();
                this.methodHandle.invoke(buf, 0, buf.length);
            }
            callback.succeeded();
        }
        catch (Throwable t) {
            callback.failed(t);
        }
        finally {
            if (frame.isFin()) {
                this.out = null;
                this.size = 0;
            }
        }
    }

    private void aggregatePayload(Frame frame) throws IOException {
        if (frame.hasPayload()) {
            ByteBuffer payload = frame.getPayload();
            if (this.out == null) {
                this.out = new ByteArrayOutputStream(65535);
            }
            BufferUtil.writeTo(payload, this.out);
        }
    }
}

