/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpInputOverHTTP;
import org.eclipse.jetty.server.HttpTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelOverHttp
extends HttpChannel
implements HttpParser.RequestHandler,
ComplianceViolation.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannelOverHttp.class);
    private static final HttpField PREAMBLE_UPGRADE_H2C = new HttpField(HttpHeader.UPGRADE, "h2c");
    private final HttpConnection _httpConnection;
    private final RequestBuilder _requestBuilder = new RequestBuilder();
    private MetaData.Request _metadata;
    private HttpField _connection;
    private HttpField _upgrade = null;
    private boolean _delayedForContent;
    private boolean _unknownExpectation = false;
    private boolean _expect100Continue = false;
    private boolean _expect102Processing = false;
    private List<String> _complianceViolations;
    private HttpFields.Mutable _trailers;

    public HttpChannelOverHttp(HttpConnection httpConnection, Connector connector, HttpConfiguration config, EndPoint endPoint, HttpTransport transport) {
        super(connector, config, endPoint, transport);
        this._httpConnection = httpConnection;
    }

    @Override
    public void abort(Throwable failure) {
        super.abort(failure);
        this._httpConnection.getGenerator().setPersistent(false);
    }

    @Override
    public void badMessage(BadMessageException failure) {
        this._httpConnection.getGenerator().setPersistent(false);
        try {
            if (this._metadata == null) {
                this._metadata = this._requestBuilder.build();
            }
            this.onRequest(this._metadata);
            this.getRequest().getHttpInput().earlyEOF();
        }
        catch (Exception e) {
            LOG.trace("IGNORED", e);
        }
        this.onBadMessage(failure);
    }

    @Override
    public boolean content(ByteBuffer content) {
        HttpInput.Content c = this._httpConnection.newContent(content);
        boolean handle = this.onContent(c) || this._delayedForContent;
        this._delayedForContent = false;
        return handle;
    }

    @Override
    public boolean contentComplete() {
        boolean handle = this.onContentComplete() || this._delayedForContent;
        this._delayedForContent = false;
        return handle;
    }

    @Override
    public void continue100(int available) throws IOException {
        if (this.isExpecting100Continue()) {
            this._expect100Continue = false;
            if (available == 0) {
                if (this.getResponse().isCommitted()) {
                    throw new IOException("Committed before 100 Continues");
                }
                boolean committed = this.sendResponse(HttpGenerator.CONTINUE_100_INFO, null, false);
                if (!committed) {
                    throw new IOException("Concurrent commit while trying to send 100-Continue");
                }
            }
        }
    }

    @Override
    public void earlyEOF() {
        this._httpConnection.getGenerator().setPersistent(false);
        if (this._metadata == null) {
            this._httpConnection.close();
        } else if (this.onEarlyEOF() || this._delayedForContent) {
            this._delayedForContent = false;
            this.handle();
        }
    }

    @Override
    public EndPoint getTunnellingEndPoint() {
        return this.getEndPoint();
    }

    @Override
    public boolean headerComplete() {
        boolean persistent;
        this._metadata = this._requestBuilder.build();
        this.onRequest(this._metadata);
        if (this._complianceViolations != null && !this._complianceViolations.isEmpty()) {
            this.getRequest().setAttribute("org.eclipse.jetty.http.compliance.violations", this._complianceViolations);
            this._complianceViolations = null;
        }
        switch (this._metadata.getHttpVersion()) {
            case HTTP_0_9: {
                persistent = false;
                break;
            }
            case HTTP_1_0: {
                persistent = this.getHttpConfiguration().isPersistentConnectionsEnabled() ? (this._connection != null ? (this._connection.contains(HttpHeaderValue.KEEP_ALIVE.asString()) ? true : this._requestBuilder.getFields().contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString())) : false) : false;
                if (!persistent) {
                    persistent = HttpMethod.CONNECT.is(this._metadata.getMethod());
                }
                if (!persistent) break;
                this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE);
                break;
            }
            case HTTP_1_1: {
                if (this._unknownExpectation) {
                    this.badMessage(new BadMessageException(417));
                    return false;
                }
                persistent = this.getHttpConfiguration().isPersistentConnectionsEnabled() ? (this._connection != null ? (this._connection.contains(HttpHeaderValue.CLOSE.asString()) ? false : !this._requestBuilder.getFields().contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) : true) : false;
                if (!persistent) {
                    persistent = HttpMethod.CONNECT.is(this._metadata.getMethod());
                }
                if (!persistent) {
                    this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                }
                if (this._upgrade == null || !this.upgrade()) break;
                return true;
            }
            case HTTP_2: {
                this._upgrade = PREAMBLE_UPGRADE_H2C;
                if (HttpMethod.PRI.is(this._metadata.getMethod()) && "*".equals(this._metadata.getURI().getPath()) && this._requestBuilder.getFields().size() == 0 && this.upgrade()) {
                    return true;
                }
                this.badMessage(new BadMessageException(426));
                this._httpConnection.getParser().close();
                return false;
            }
            default: {
                throw new IllegalStateException("unsupported version " + this._metadata.getHttpVersion());
            }
        }
        if (!persistent) {
            this._httpConnection.getGenerator().setPersistent(false);
        }
        this._delayedForContent = this.getHttpConfiguration().isDelayDispatchUntilContent() && (this._httpConnection.getParser().getContentLength() > 0L || this._httpConnection.getParser().isChunking()) && !this.isExpecting100Continue() && !this.isCommitted() && this._httpConnection.isRequestBufferEmpty();
        return !this._delayedForContent;
    }

    @Override
    public boolean isExpecting100Continue() {
        return this._expect100Continue;
    }

    @Override
    public boolean isExpecting102Processing() {
        return this._expect102Processing;
    }

    @Override
    public boolean isTunnellingSupported() {
        return true;
    }

    @Override
    public boolean isUseOutputDirectByteBuffers() {
        return this._httpConnection.isUseOutputDirectByteBuffers();
    }

    @Override
    public boolean messageComplete() {
        if (this._trailers != null) {
            this.onTrailers(this._trailers);
        }
        return this.onRequestComplete();
    }

    @Override
    public void onAsyncWaitForContent() {
        this._httpConnection.asyncReadFillInterested();
    }

    @Override
    public void onBlockWaitForContent() {
        this._httpConnection.blockingReadFillInterested();
    }

    @Override
    public void onBlockWaitForContentFailure(Throwable failure) {
        this._httpConnection.blockingReadFailure(failure);
    }

    @Override
    public void onComplianceViolation(ComplianceViolation.Mode mode, ComplianceViolation violation, String details) {
        if (this._httpConnection.isRecordHttpComplianceViolations()) {
            if (this._complianceViolations == null) {
                this._complianceViolations = new ArrayList<String>();
            }
            String record = String.format("%s (see %s) in mode %s for %s in %s", violation.getDescription(), violation.getURL(), mode, details, this.getHttpTransport());
            this._complianceViolations.add(record);
            if (LOG.isDebugEnabled()) {
                LOG.debug(record);
            }
        }
    }

    @Override
    public void parsedHeader(HttpField field) {
        HttpHeader header = field.getHeader();
        String value = field.getValue();
        if (header != null) {
            block0 : switch (header) {
                case CONNECTION: {
                    this._connection = field;
                    break;
                }
                case HOST: {
                    if (field instanceof HostPortHttpField || value == null || value.isEmpty()) break;
                    field = new HostPortHttpField(value);
                    break;
                }
                case EXPECT: {
                    if (!HttpVersion.HTTP_1_1.equals((Object)this._requestBuilder.version())) break;
                    HttpHeaderValue expect = HttpHeaderValue.CACHE.get(value);
                    switch (expect == null ? HttpHeaderValue.UNKNOWN : expect) {
                        case CONTINUE: {
                            this._expect100Continue = true;
                            break block0;
                        }
                        case PROCESSING: {
                            this._expect102Processing = true;
                            break block0;
                        }
                    }
                    String[] values = field.getValues();
                    block14: for (int i2 = 0; values != null && i2 < values.length; ++i2) {
                        expect = HttpHeaderValue.CACHE.get(values[i2].trim());
                        if (expect == null) {
                            this._unknownExpectation = true;
                            continue;
                        }
                        switch (expect) {
                            case CONTINUE: {
                                this._expect100Continue = true;
                                continue block14;
                            }
                            case PROCESSING: {
                                this._expect102Processing = true;
                                continue block14;
                            }
                            default: {
                                this._unknownExpectation = true;
                            }
                        }
                    }
                    break;
                }
                case UPGRADE: {
                    this._upgrade = field;
                    break;
                }
            }
        }
        this._requestBuilder.getFields().add(field);
    }

    @Override
    public void parsedTrailer(HttpField field) {
        if (this._trailers == null) {
            this._trailers = HttpFields.build();
        }
        this._trailers.add(field);
    }

    @Override
    public void recycle() {
        super.recycle();
        this._unknownExpectation = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
        this._connection = null;
        this._upgrade = null;
        this._trailers = null;
        this._metadata = null;
    }

    @Override
    public void startRequest(String method, String uri, HttpVersion version) {
        this._requestBuilder.request(method, uri, version);
        this._unknownExpectation = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
    }

    @Override
    protected boolean checkAndPrepareUpgrade() {
        return false;
    }

    @Override
    protected void handleException(Throwable x) {
        this._httpConnection.getGenerator().setPersistent(false);
        super.handleException(x);
    }

    @Override
    protected HttpInput newHttpInput(HttpChannelState state) {
        return new HttpInputOverHTTP(state);
    }

    private boolean upgrade() throws BadMessageException {
        boolean isUpgradedH2C;
        if (LOG.isDebugEnabled()) {
            LOG.debug("upgrade {} {}", (Object)this, (Object)this._upgrade);
        }
        boolean bl = isUpgradedH2C = this._upgrade == PREAMBLE_UPGRADE_H2C;
        if (!(isUpgradedH2C || this._connection != null && this._connection.contains("upgrade"))) {
            throw new BadMessageException(400);
        }
        ConnectionFactory.Upgrading factory = this.getConnector().getConnectionFactories().stream().filter(f -> f instanceof ConnectionFactory.Upgrading).map(ConnectionFactory.Upgrading.class::cast).filter(f -> f.getProtocols().contains(this._upgrade.getValue())).findAny().orElse(null);
        if (factory == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No factory for {} in {}", (Object)this._upgrade, (Object)this.getConnector());
            }
            return false;
        }
        HttpFields.Mutable response101 = HttpFields.build();
        Connection upgradeConnection = factory.upgradeConnection(this.getConnector(), this.getEndPoint(), this._metadata, response101);
        if (upgradeConnection == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Upgrade ignored for {} by {}", (Object)this._upgrade, (Object)factory);
            }
            return false;
        }
        try {
            if (!isUpgradedH2C) {
                this.sendResponse(new MetaData.Response(HttpVersion.HTTP_1_1, 101, response101, 0L), null, true);
            }
        }
        catch (IOException e) {
            throw new BadMessageException(500, null, e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Upgrade from {} to {}", (Object)this.getEndPoint().getConnection(), (Object)upgradeConnection);
        }
        this.getRequest().setAttribute(HttpTransport.UPGRADE_CONNECTION_ATTRIBUTE, upgradeConnection);
        this.getHttpTransport().onCompleted();
        return true;
    }

    boolean onIdleTimeout(Throwable timeout) {
        if (this._delayedForContent) {
            this._delayedForContent = false;
            this.getRequest().getHttpInput().onIdleTimeout(timeout);
            this.execute(this);
            return false;
        }
        return true;
    }

    private static class RequestBuilder {
        private final HttpFields.Mutable _fieldsBuilder = HttpFields.build();
        private final HttpURI.Mutable _uriBuilder = HttpURI.build();
        private String _method;
        private HttpVersion _version;

        private RequestBuilder() {
        }

        public String method() {
            return this._method;
        }

        public void request(String method, String uri, HttpVersion version) {
            this._method = method;
            this._uriBuilder.uri(method, uri);
            this._version = version;
            this._fieldsBuilder.clear();
        }

        public HttpFields.Mutable getFields() {
            return this._fieldsBuilder;
        }

        public MetaData.Request build() {
            return new MetaData.Request(this._method, this._uriBuilder, this._version, this._fieldsBuilder);
        }

        public HttpVersion version() {
            return this._version;
        }
    }
}

