/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import org.eclipse.jetty.logging.JettyLoggerConfiguration;
import org.eclipse.jetty.logging.JettyLoggerFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.IMarkerFactory;
import org.slf4j.helpers.BasicMarkerFactory;
import org.slf4j.helpers.NOPMDCAdapter;
import org.slf4j.spi.MDCAdapter;
import org.slf4j.spi.SLF4JServiceProvider;

public class JettyLoggingServiceProvider
implements SLF4JServiceProvider {
    public static String REQUESTED_API_VERSION = "1.8.99";
    private JettyLoggerFactory loggerFactory;
    private BasicMarkerFactory markerFactory;
    private MDCAdapter mdcAdapter;

    @Override
    public void initialize() {
        JettyLoggerConfiguration config = new JettyLoggerConfiguration().load(this.getClass().getClassLoader());
        this.loggerFactory = new JettyLoggerFactory(config);
        this.markerFactory = new BasicMarkerFactory();
        this.mdcAdapter = new NOPMDCAdapter();
    }

    public JettyLoggerFactory getJettyLoggerFactory() {
        return this.loggerFactory;
    }

    @Override
    public ILoggerFactory getLoggerFactory() {
        return this.getJettyLoggerFactory();
    }

    @Override
    public IMarkerFactory getMarkerFactory() {
        return this.markerFactory;
    }

    @Override
    public MDCAdapter getMDCAdapter() {
        return this.mdcAdapter;
    }

    @Override
    public String getRequesteApiVersion() {
        return REQUESTED_API_VERSION;
    }
}

