/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.util;

import jakarta.servlet.jsp.JspWriter;
import java.io.IOException;
import java.io.Reader;

public class EscapeXML {
    private static final String[] ESCAPES;

    private static String getEscape(char c) {
        if (c < ESCAPES.length) {
            return ESCAPES[c];
        }
        return null;
    }

    public static String escape(String src) {
        int length = 0;
        for (int i2 = 0; i2 < src.length(); ++i2) {
            char c = src.charAt(i2);
            String escape = EscapeXML.getEscape(c);
            if (escape != null) {
                length += escape.length();
                continue;
            }
            ++length;
        }
        if (length == src.length()) {
            return src;
        }
        StringBuilder buf = new StringBuilder(length);
        for (int i3 = 0; i3 < src.length(); ++i3) {
            char c = src.charAt(i3);
            String escape = EscapeXML.getEscape(c);
            if (escape != null) {
                buf.append(escape);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static void emit(Object src, boolean escapeXml, JspWriter out) throws IOException {
        if (src instanceof Reader) {
            EscapeXML.emit((Reader)src, escapeXml, out);
        } else {
            EscapeXML.emit(String.valueOf(src), escapeXml, out);
        }
    }

    public static void emit(String src, boolean escapeXml, JspWriter out) throws IOException {
        if (escapeXml) {
            EscapeXML.emit(src, out);
        } else {
            out.write(src);
        }
    }

    public static void emit(String src, JspWriter out) throws IOException {
        int from;
        int end = src.length();
        for (int to = from = 0; to < end; ++to) {
            String escape = EscapeXML.getEscape(src.charAt(to));
            if (escape == null) continue;
            if (to != from) {
                out.write(src, from, to - from);
            }
            out.write(escape);
            from = to + 1;
        }
        if (from != end) {
            out.write(src, from, end - from);
        }
    }

    public static void emit(Reader src, boolean escapeXml, JspWriter out) throws IOException {
        int count;
        int bufferSize = out.getBufferSize();
        if (bufferSize == 0) {
            bufferSize = 4096;
        }
        char[] buffer = new char[bufferSize];
        while ((count = src.read(buffer)) > 0) {
            if (escapeXml) {
                EscapeXML.emit(buffer, 0, count, out);
                continue;
            }
            out.write(buffer, 0, count);
        }
    }

    public static void emit(char[] buffer, int from, int count, JspWriter out) throws IOException {
        int end = from + count;
        for (int to = from; to < end; ++to) {
            String escape = EscapeXML.getEscape(buffer[to]);
            if (escape == null) continue;
            if (to != from) {
                out.write(buffer, from, to - from);
            }
            out.write(escape);
            from = to + 1;
        }
        if (from != end) {
            out.write(buffer, from, end - from);
        }
    }

    static {
        int size = 63;
        ESCAPES = new String[size];
        EscapeXML.ESCAPES[60] = "&lt;";
        EscapeXML.ESCAPES[62] = "&gt;";
        EscapeXML.ESCAPES[38] = "&amp;";
        EscapeXML.ESCAPES[39] = "&#039;";
        EscapeXML.ESCAPES[34] = "&#034;";
    }
}

