/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.sql;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.jstl.sql.SQLExecutionTag;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.sql.DataSourceUtil;
import org.apache.taglibs.standard.tag.common.sql.TransactionTagSupport;

public abstract class UpdateTagSupport
extends BodyTagSupport
implements TryCatchFinally,
SQLExecutionTag {
    private String var;
    private int scope;
    protected Object rawDataSource;
    protected boolean dataSourceSpecified;
    protected String sql;
    private Connection conn;
    private List parameters;
    private boolean isPartOfTransaction;

    public UpdateTagSupport() {
        this.init();
    }

    private void init() {
        this.rawDataSource = null;
        this.sql = null;
        this.conn = null;
        this.parameters = null;
        this.dataSourceSpecified = false;
        this.isPartOfTransaction = false;
        this.scope = 1;
        this.var = null;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scopeName) {
        this.scope = Util.getScope(scopeName);
    }

    public int doStartTag() throws JspException {
        try {
            this.conn = this.getConnection();
        }
        catch (SQLException e) {
            throw new JspException(this.sql + ": " + e.getMessage(), e);
        }
        return 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int doEndTag() throws JspException {
        int result;
        block11: {
            String sqlStatement = null;
            if (this.sql != null) {
                sqlStatement = this.sql;
            } else if (this.bodyContent != null) {
                sqlStatement = this.bodyContent.getString();
            }
            if (sqlStatement == null) throw new JspTagException(Resources.getMessage("SQL_NO_STATEMENT"));
            if (sqlStatement.trim().length() == 0) {
                throw new JspTagException(Resources.getMessage("SQL_NO_STATEMENT"));
            }
            result = 0;
            PreparedStatement ps = null;
            try {
                try {
                    ps = this.conn.prepareStatement(sqlStatement);
                    this.setParameters(ps, this.parameters);
                    result = ps.executeUpdate();
                }
                catch (Throwable e) {
                    throw new JspException(sqlStatement + ": " + e.getMessage(), e);
                }
                Object var6_4 = null;
                if (ps == null) break block11;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (ps == null) throw throwable;
                try {
                    ps.close();
                    throw throwable;
                }
                catch (SQLException sqe) {
                    throw new JspException(sqe.getMessage(), sqe);
                }
            }
            try {}
            catch (SQLException sqe) {
                throw new JspException(sqe.getMessage(), sqe);
            }
            ps.close();
        }
        if (this.var == null) return 6;
        this.pageContext.setAttribute(this.var, new Integer(result), this.scope);
        return 6;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        if (this.conn != null && !this.isPartOfTransaction) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.parameters = null;
        this.conn = null;
    }

    public void addSQLParameter(Object o) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(o);
    }

    private Connection getConnection() throws JspException, SQLException {
        Connection conn = null;
        this.isPartOfTransaction = false;
        TransactionTagSupport parent = (TransactionTagSupport)UpdateTagSupport.findAncestorWithClass(this, TransactionTagSupport.class);
        if (parent != null) {
            if (this.dataSourceSpecified) {
                throw new JspTagException(Resources.getMessage("ERROR_NESTED_DATASOURCE"));
            }
            conn = parent.getSharedConnection();
            this.isPartOfTransaction = true;
        } else {
            if (this.rawDataSource == null && this.dataSourceSpecified) {
                throw new JspException(Resources.getMessage("SQL_DATASOURCE_NULL"));
            }
            DataSource dataSource = DataSourceUtil.getDataSource(this.rawDataSource, this.pageContext);
            try {
                conn = dataSource.getConnection();
            }
            catch (Exception ex) {
                throw new JspException(Resources.getMessage("DATASOURCE_INVALID", ex.toString()));
            }
        }
        return conn;
    }

    private void setParameters(PreparedStatement ps, List parameters) throws SQLException {
        if (parameters != null) {
            for (int i2 = 0; i2 < parameters.size(); ++i2) {
                ps.setObject(i2 + 1, parameters.get(i2));
            }
        }
    }
}

