/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.io.CyclicTimeout;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CyclicTimeouts<T extends Expirable>
implements Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(CyclicTimeouts.class);
    private final AtomicLong earliestTimeout = new AtomicLong(Long.MAX_VALUE);
    private final CyclicTimeout cyclicTimeout;

    public CyclicTimeouts(Scheduler scheduler) {
        this.cyclicTimeout = new CyclicTimeout(scheduler){

            @Override
            public void onTimeoutExpired() {
                CyclicTimeouts.this.onTimeoutExpired();
            }
        };
    }

    protected abstract Iterator<T> iterator();

    protected abstract boolean onExpired(T var1);

    private void onTimeoutExpired() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} timeouts check", (Object)this);
        }
        long now = System.nanoTime();
        long earliest = Long.MAX_VALUE;
        this.earliestTimeout.set(earliest);
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            Expirable expirable = (Expirable)iterator.next();
            long expiresAt = expirable.getExpireNanoTime();
            if (expiresAt == -1L) continue;
            if (expiresAt <= now) {
                if (!this.onExpired(expirable)) continue;
                iterator.remove();
                continue;
            }
            earliest = Math.min(earliest, expiresAt);
        }
        if (earliest < Long.MAX_VALUE) {
            this.schedule(earliest);
        }
    }

    public void schedule(T expirable) {
        long expiresAt = expirable.getExpireNanoTime();
        if (expiresAt < Long.MAX_VALUE) {
            this.schedule(expiresAt);
        }
    }

    private void schedule(long expiresAt) {
        long prevEarliest = this.earliestTimeout.getAndUpdate(t -> Math.min(t, expiresAt));
        if (expiresAt < prevEarliest) {
            long delay = Math.max(0L, expiresAt - System.nanoTime());
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} scheduling timeout in {} ms", (Object)this, (Object)TimeUnit.NANOSECONDS.toMillis(delay));
            }
            this.cyclicTimeout.schedule(delay, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void destroy() {
        this.cyclicTimeout.destroy();
    }

    public static interface Expirable {
        public long getExpireNanoTime();
    }
}

