/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateLifeCycleListener
implements LifeCycle.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(StateLifeCycleListener.class);
    private final Path _filename;

    public StateLifeCycleListener(String filename) {
        this._filename = Paths.get(filename, new String[0]).toAbsolutePath();
        if (LOG.isDebugEnabled()) {
            LOG.debug("State File: {}", (Object)this._filename);
        }
    }

    private void writeState(String action, LifeCycle lifecycle) {
        try (BufferedWriter out = Files.newBufferedWriter(this._filename, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            out.append(action).append(" ").append(lifecycle.toString()).append("\n");
        }
        catch (Exception e) {
            LOG.warn("Unable to write state", e);
        }
    }

    @Override
    public void lifeCycleStarting(LifeCycle event) {
        this.writeState("STARTING", event);
    }

    @Override
    public void lifeCycleStarted(LifeCycle event) {
        this.writeState("STARTED", event);
    }

    @Override
    public void lifeCycleFailure(LifeCycle event, Throwable cause) {
        this.writeState("FAILED", event);
    }

    @Override
    public void lifeCycleStopping(LifeCycle event) {
        this.writeState("STOPPING", event);
    }

    @Override
    public void lifeCycleStopped(LifeCycle event) {
        this.writeState("STOPPED", event);
    }
}

