/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.sql.SQLExecutionTag;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import javax.sql.DataSource;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.sql.DataSourceUtil;
import org.apache.taglibs.standard.tag.common.sql.ResultImpl;
import org.apache.taglibs.standard.tag.common.sql.TransactionTagSupport;

public abstract class QueryTagSupport
extends BodyTagSupport
implements TryCatchFinally,
SQLExecutionTag {
    private String var;
    private int scope;
    protected Object rawDataSource;
    protected boolean dataSourceSpecified;
    protected String sql;
    protected int maxRows;
    protected boolean maxRowsSpecified;
    protected int startRow;
    private Connection conn;
    private List parameters;
    private boolean isPartOfTransaction;

    public QueryTagSupport() {
        this.init();
    }

    private void init() {
        this.startRow = 0;
        this.maxRows = -1;
        this.dataSourceSpecified = false;
        this.maxRowsSpecified = false;
        this.isPartOfTransaction = false;
        this.conn = null;
        this.rawDataSource = null;
        this.parameters = null;
        this.sql = null;
        this.var = null;
        this.scope = 1;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scopeName) {
        this.scope = Util.getScope(scopeName);
    }

    public void addSQLParameter(Object o) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(o);
    }

    public int doStartTag() throws JspException {
        Object obj;
        if (!this.maxRowsSpecified && (obj = Config.find(this.pageContext, "javax.servlet.jsp.jstl.sql.maxRows")) != null) {
            if (obj instanceof Integer) {
                this.maxRows = (Integer)obj;
            } else if (obj instanceof String) {
                try {
                    this.maxRows = Integer.parseInt((String)obj);
                }
                catch (NumberFormatException nfe) {
                    throw new JspException(Resources.getMessage("SQL_MAXROWS_PARSE_ERROR", (String)obj), nfe);
                }
            } else {
                throw new JspException(Resources.getMessage("SQL_MAXROWS_INVALID"));
            }
        }
        try {
            this.conn = this.getConnection();
        }
        catch (SQLException e) {
            throw new JspException(this.sql + ": " + e.getMessage(), e);
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int doEndTag() throws JspException {
        ResultImpl result;
        block35: {
            SQLException sqe222;
            SQLException psCloseExc;
            SQLException rsCloseExc;
            Throwable queryError;
            ResultSet rs;
            PreparedStatement ps;
            String sqlStatement;
            block31: {
                sqlStatement = null;
                if (this.sql != null) {
                    sqlStatement = this.sql;
                } else if (this.bodyContent != null) {
                    sqlStatement = this.bodyContent.getString();
                }
                if (sqlStatement == null || sqlStatement.trim().length() == 0) {
                    throw new JspTagException(Resources.getMessage("SQL_NO_STATEMENT"));
                }
                if (this.startRow < 0 || this.maxRows < -1) {
                    throw new JspException(Resources.getMessage("PARAM_BAD_VALUE"));
                }
                result = null;
                ps = null;
                rs = null;
                queryError = null;
                ps = this.conn.prepareStatement(sqlStatement);
                this.setParameters(ps, this.parameters);
                rs = ps.executeQuery();
                result = new ResultImpl(rs, this.startRow, this.maxRows);
                Object var8_6 = null;
                rsCloseExc = null;
                psCloseExc = null;
                if (rs == null) break block31;
                try {
                    rs.close();
                }
                catch (SQLException sqe222) {
                    rsCloseExc = sqe222;
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sqe222) {
                    psCloseExc = sqe222;
                }
            }
            if (queryError != null) {
                throw new JspException(sqlStatement + ": " + queryError.getMessage(), queryError);
            }
            if (rsCloseExc != null) {
                throw new JspException(rsCloseExc.getMessage(), rsCloseExc);
            }
            if (psCloseExc != null) {
                throw new JspException(psCloseExc.getMessage(), psCloseExc);
            }
            break block35;
            {
                catch (Throwable e) {
                    SQLException sqe222;
                    queryError = e;
                    Object var8_7 = null;
                    rsCloseExc = null;
                    psCloseExc = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sqe222) {
                            rsCloseExc = sqe222;
                        }
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sqe222) {
                            psCloseExc = sqe222;
                        }
                    }
                    if (queryError != null) {
                        throw new JspException(sqlStatement + ": " + queryError.getMessage(), queryError);
                    }
                    if (rsCloseExc != null) {
                        throw new JspException(rsCloseExc.getMessage(), rsCloseExc);
                    }
                    if (psCloseExc != null) {
                        throw new JspException(psCloseExc.getMessage(), psCloseExc);
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException sqe222;
                Object var8_8 = null;
                rsCloseExc = null;
                psCloseExc = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqe222) {
                        rsCloseExc = sqe222;
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sqe222) {
                        psCloseExc = sqe222;
                    }
                }
                if (queryError != null) {
                    throw new JspException(sqlStatement + ": " + queryError.getMessage(), queryError);
                }
                if (rsCloseExc != null) {
                    throw new JspException(rsCloseExc.getMessage(), rsCloseExc);
                }
                if (psCloseExc != null) {
                    throw new JspException(psCloseExc.getMessage(), psCloseExc);
                }
                throw throwable;
            }
        }
        this.pageContext.setAttribute(this.var, result, this.scope);
        return 6;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        if (this.conn != null && !this.isPartOfTransaction) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.conn = null;
        this.parameters = null;
    }

    private Connection getConnection() throws JspException, SQLException {
        Connection conn = null;
        this.isPartOfTransaction = false;
        TransactionTagSupport parent = (TransactionTagSupport)QueryTagSupport.findAncestorWithClass(this, TransactionTagSupport.class);
        if (parent != null) {
            if (this.dataSourceSpecified) {
                throw new JspTagException(Resources.getMessage("ERROR_NESTED_DATASOURCE"));
            }
            conn = parent.getSharedConnection();
            this.isPartOfTransaction = true;
        } else {
            if (this.rawDataSource == null && this.dataSourceSpecified) {
                throw new JspException(Resources.getMessage("SQL_DATASOURCE_NULL"));
            }
            DataSource dataSource = DataSourceUtil.getDataSource(this.rawDataSource, this.pageContext);
            try {
                conn = dataSource.getConnection();
            }
            catch (Exception ex) {
                throw new JspException(Resources.getMessage("DATASOURCE_INVALID", ex.toString()));
            }
        }
        return conn;
    }

    private void setParameters(PreparedStatement ps, List parameters) throws SQLException {
        if (parameters != null) {
            for (int i2 = 0; i2 < parameters.size(); ++i2) {
                ps.setObject(i2 + 1, parameters.get(i2));
            }
        }
    }
}

