/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.servlet.ServletContext;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketContainer;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WebSocketSessionListener;
import org.eclipse.jetty.websocket.common.SessionTracker;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.exception.WebSocketException;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.websocket.server.internal.JettyServerFrameHandlerFactory;
import org.eclipse.jetty.websocket.servlet.FrameHandlerFactory;
import org.eclipse.jetty.websocket.servlet.WebSocketMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketServerContainer
extends ContainerLifeCycle
implements WebSocketContainer,
WebSocketPolicy,
LifeCycle.Listener {
    public static final String JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE = WebSocketContainer.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(JettyWebSocketServerContainer.class);
    private final WebSocketMapping webSocketMapping;
    private final WebSocketComponents webSocketComponents;
    private final FrameHandlerFactory frameHandlerFactory;
    private final Executor executor;
    private final Configuration.ConfigurationCustomizer customizer = new Configuration.ConfigurationCustomizer();
    private final List<WebSocketSessionListener> sessionListeners = new ArrayList<WebSocketSessionListener>();
    private final SessionTracker sessionTracker = new SessionTracker();

    public static JettyWebSocketServerContainer getContainer(ServletContext servletContext) {
        return (JettyWebSocketServerContainer)servletContext.getAttribute(JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE);
    }

    public static JettyWebSocketServerContainer ensureContainer(ServletContext servletContext) {
        ServletContextHandler contextHandler = ServletContextHandler.getServletContextHandler(servletContext, "Javax Websocket");
        if (contextHandler.getServer() == null) {
            throw new IllegalStateException("Server has not been set on the ServletContextHandler");
        }
        JettyWebSocketServerContainer container = JettyWebSocketServerContainer.getContainer(servletContext);
        if (container == null) {
            Executor executor = (Executor)servletContext.getAttribute("org.eclipse.jetty.server.Executor");
            if (executor == null) {
                executor = contextHandler.getServer().getThreadPool();
            }
            container = new JettyWebSocketServerContainer(contextHandler, WebSocketMapping.ensureMapping(servletContext, "org.eclipse.jetty.websocket.servlet.WebSocketMapping"), WebSocketComponents.ensureWebSocketComponents(servletContext), executor);
            servletContext.setAttribute(JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE, container);
            contextHandler.addManaged(container);
            contextHandler.addEventListener(container);
        }
        return container;
    }

    JettyWebSocketServerContainer(ServletContextHandler contextHandler, WebSocketMapping webSocketMapping, WebSocketComponents webSocketComponents, Executor executor) {
        this.webSocketMapping = webSocketMapping;
        this.webSocketComponents = webSocketComponents;
        this.executor = executor;
        JettyServerFrameHandlerFactory factory = contextHandler.getBean(JettyServerFrameHandlerFactory.class);
        if (factory == null) {
            factory = new JettyServerFrameHandlerFactory(this);
            contextHandler.addManaged(factory);
            contextHandler.addEventListener(factory);
        }
        this.frameHandlerFactory = factory;
        this.addSessionListener(this.sessionTracker);
    }

    public void addMapping(String pathSpec, JettyWebSocketCreator creator) {
        PathSpec ps = WebSocketMapping.parsePathSpec(pathSpec);
        if (this.webSocketMapping.getMapping(ps) != null) {
            throw new WebSocketException("Duplicate WebSocket Mapping for PathSpec");
        }
        this.webSocketMapping.addMapping(ps, (req, resp) -> creator.createWebSocket(new JettyServerUpgradeRequest(req), new JettyServerUpgradeResponse(resp)), this.frameHandlerFactory, this.customizer);
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void addSessionListener(WebSocketSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    @Override
    public boolean removeSessionListener(WebSocketSessionListener listener) {
        return this.sessionListeners.remove(listener);
    }

    @Override
    public void notifySessionListeners(Consumer<WebSocketSessionListener> consumer) {
        for (WebSocketSessionListener listener : this.sessionListeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable x) {
                LOG.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    @Override
    public Collection<Session> getOpenSessions() {
        return this.sessionTracker.getSessions();
    }

    @Override
    public WebSocketBehavior getBehavior() {
        return WebSocketBehavior.SERVER;
    }

    @Override
    public Duration getIdleTimeout() {
        return this.customizer.getIdleTimeout();
    }

    @Override
    public int getInputBufferSize() {
        return this.customizer.getInputBufferSize();
    }

    @Override
    public int getOutputBufferSize() {
        return this.customizer.getOutputBufferSize();
    }

    @Override
    public long getMaxBinaryMessageSize() {
        return this.customizer.getMaxBinaryMessageSize();
    }

    @Override
    public long getMaxTextMessageSize() {
        return this.customizer.getMaxTextMessageSize();
    }

    @Override
    public long getMaxFrameSize() {
        return this.customizer.getMaxFrameSize();
    }

    @Override
    public boolean isAutoFragment() {
        return this.customizer.isAutoFragment();
    }

    @Override
    public void setIdleTimeout(Duration duration) {
        this.customizer.setIdleTimeout(duration);
    }

    @Override
    public void setInputBufferSize(int size) {
        this.customizer.setInputBufferSize(size);
    }

    @Override
    public void setOutputBufferSize(int size) {
        this.customizer.setOutputBufferSize(size);
    }

    @Override
    public void setMaxBinaryMessageSize(long size) {
        this.customizer.setMaxBinaryMessageSize(size);
    }

    @Override
    public void setMaxTextMessageSize(long size) {
        this.customizer.setMaxTextMessageSize(size);
    }

    @Override
    public void setMaxFrameSize(long maxFrameSize) {
        this.customizer.setMaxFrameSize(maxFrameSize);
    }

    @Override
    public void setAutoFragment(boolean autoFragment) {
        this.customizer.setAutoFragment(autoFragment);
    }
}

