/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.client;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.WebSocketExtensionRegistry;
import org.eclipse.jetty.websocket.core.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.core.client.HttpClientProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketCoreClient
extends ContainerLifeCycle {
    public static final String WEBSOCKET_CORECLIENT_ATTRIBUTE = WebSocketCoreClient.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketCoreClient.class);
    private final HttpClient httpClient;
    private WebSocketComponents components;

    public WebSocketCoreClient() {
        this(null, new WebSocketComponents());
    }

    public WebSocketCoreClient(WebSocketComponents webSocketComponents) {
        this(null, webSocketComponents);
    }

    public WebSocketCoreClient(HttpClient httpClient, WebSocketComponents webSocketComponents) {
        if (httpClient == null) {
            httpClient = Objects.requireNonNull(HttpClientProvider.get());
        }
        this.httpClient = httpClient;
        this.components = webSocketComponents;
        this.addBean(httpClient);
    }

    public CompletableFuture<CoreSession> connect(FrameHandler frameHandler, URI wsUri) throws IOException {
        ClientUpgradeRequest request = ClientUpgradeRequest.from(this, wsUri, frameHandler);
        return this.connect(request);
    }

    public CompletableFuture<CoreSession> connect(ClientUpgradeRequest request) throws IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException(WebSocketCoreClient.class.getSimpleName() + "@" + this.hashCode() + " is not started");
        }
        for (ExtensionConfig reqExt : request.getExtensions()) {
            if (this.components.getExtensionRegistry().isAvailable(reqExt.getName())) continue;
            throw new IllegalArgumentException("Requested extension [" + reqExt.getName() + "] is not installed");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("connect to websocket {}", (Object)request.getURI());
        }
        return request.sendAsync();
    }

    public WebSocketExtensionRegistry getExtensionRegistry() {
        return this.components.getExtensionRegistry();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public DecoratedObjectFactory getObjectFactory() {
        return this.components.getObjectFactory();
    }

    public WebSocketComponents getWebSocketComponents() {
        return this.components;
    }
}

