/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.eclipse.jetty.logging.JettyAppender;
import org.eclipse.jetty.logging.JettyLogger;
import org.eclipse.jetty.logging.JettyLoggerConfiguration;
import org.eclipse.jetty.logging.StdErrAppender;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class JettyLoggerFactory
implements ILoggerFactory {
    private static final String ROOT_LOGGER_NAME = "";
    private final JettyLoggerConfiguration configuration;
    private final JettyLogger rootLogger;
    private ConcurrentMap<String, JettyLogger> loggerMap;

    public JettyLoggerFactory(JettyLoggerConfiguration config) {
        this.configuration = Objects.requireNonNull(config, "JettyLoggerConfiguration");
        this.loggerMap = new ConcurrentHashMap<String, JettyLogger>();
        StdErrAppender appender = new StdErrAppender(this.configuration);
        this.rootLogger = new JettyLogger(this, ROOT_LOGGER_NAME, appender);
        this.loggerMap.put(ROOT_LOGGER_NAME, this.rootLogger);
        this.rootLogger.setLevel(this.configuration.getLevel(ROOT_LOGGER_NAME));
    }

    public JettyLogger getJettyLogger(String name) {
        if (name.equals(ROOT_LOGGER_NAME)) {
            return this.getRootLogger();
        }
        return this.loggerMap.computeIfAbsent(name, this::createLogger);
    }

    @Override
    public Logger getLogger(String name) {
        return this.getJettyLogger(name);
    }

    protected void walkChildLoggers(String parentName, Consumer<JettyLogger> childConsumer) {
        Object prefix = parentName;
        if (parentName.length() > 0 && !((String)prefix).endsWith(".")) {
            prefix = (String)prefix + ".";
        }
        for (JettyLogger logger : this.loggerMap.values()) {
            if (logger.getName().equals(parentName) || !logger.getName().startsWith((String)prefix)) continue;
            childConsumer.accept(logger);
        }
    }

    public JettyLogger getRootLogger() {
        return this.rootLogger;
    }

    private JettyLogger createLogger(String name) {
        JettyAppender appender = this.rootLogger.getAppender();
        int level = this.configuration.getLevel(name);
        boolean hideStacks = this.configuration.getHideStacks(name);
        return new JettyLogger(this, name, appender, level, hideStacks);
    }

    protected static String condensePackageString(String classname) {
        if (classname == null || classname.isEmpty()) {
            return ROOT_LOGGER_NAME;
        }
        int rawLen = classname.length();
        StringBuilder dense = new StringBuilder(rawLen);
        boolean foundStart = false;
        boolean hasPackage = false;
        int startIdx = -1;
        int endIdx = -1;
        for (int i2 = 0; i2 < rawLen; ++i2) {
            char c = classname.charAt(i2);
            if (!foundStart && (foundStart = Character.isJavaIdentifierStart(c))) {
                if (startIdx >= 0) {
                    dense.append(classname.charAt(startIdx));
                    hasPackage = true;
                }
                startIdx = i2;
            }
            if (!foundStart) continue;
            if (!Character.isJavaIdentifierPart(c)) {
                foundStart = false;
                continue;
            }
            endIdx = i2;
        }
        if (startIdx >= 0 && endIdx >= startIdx) {
            if (hasPackage) {
                dense.append('.');
            }
            dense.append(classname, startIdx, endIdx + 1);
        }
        return dense.toString();
    }
}

