/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.function.Function;
import org.slf4j.event.Level;

public class JettyLoggerConfiguration {
    private static final int DEFAULT_LEVEL = Level.INFO.toInt();
    private static final boolean DEFAULT_HIDE_STACKS = false;
    private static final String SUFFIX_LEVEL = ".LEVEL";
    private static final String SUFFIX_STACKS = ".STACKS";
    private final Properties properties = new Properties();

    public JettyLoggerConfiguration() {
    }

    public JettyLoggerConfiguration(Properties props) {
        this.load(props);
    }

    public boolean getHideStacks(String name) {
        Boolean hideStacks;
        if (this.properties.isEmpty()) {
            return false;
        }
        String startName = name;
        while (startName.endsWith(".")) {
            startName = startName.substring(0, startName.length() - 1);
        }
        if (startName.endsWith(SUFFIX_STACKS)) {
            startName = startName.substring(0, startName.length() - SUFFIX_STACKS.length());
        }
        if ((hideStacks = this.walkParentLoggerNames(startName, key -> {
            String stacksBool = this.properties.getProperty(key + SUFFIX_STACKS);
            if (stacksBool != null) {
                return Boolean.parseBoolean(stacksBool);
            }
            return null;
        })) != null) {
            return hideStacks;
        }
        return false;
    }

    public int getLevel(String name) {
        String levelStr;
        Integer level;
        String startName;
        if (this.properties.isEmpty()) {
            return DEFAULT_LEVEL;
        }
        String string = startName = name != null ? name : "";
        while (startName.endsWith(".")) {
            startName = startName.substring(0, startName.length() - 1);
        }
        if (startName.endsWith(SUFFIX_LEVEL)) {
            startName = startName.substring(0, startName.length() - SUFFIX_LEVEL.length());
        }
        if ((level = this.walkParentLoggerNames(startName, key -> {
            String levelStr = this.properties.getProperty(key + SUFFIX_LEVEL);
            if (levelStr != null) {
                return this.getLevelInt((String)key, levelStr);
            }
            return null;
        })) == null && (levelStr = this.properties.getProperty("log.LEVEL")) != null) {
            level = this.getLevelInt("log", levelStr);
        }
        if (level != null) {
            return level;
        }
        return DEFAULT_LEVEL;
    }

    public TimeZone getTimeZone(String key) {
        String zoneIdStr = this.properties.getProperty(key);
        if (zoneIdStr == null) {
            return null;
        }
        return TimeZone.getTimeZone(zoneIdStr);
    }

    public JettyLoggerConfiguration load(ClassLoader loader) {
        return AccessController.doPrivileged(() -> {
            this.load(this.readProperties(loader, "jetty-logging.properties"));
            String osName = System.getProperty("os.name");
            if (osName != null && osName.length() > 0) {
                osName = osName.toLowerCase(Locale.ENGLISH).replace(' ', '-');
                this.load(this.readProperties(loader, "jetty-logging-" + osName + ".properties"));
            }
            this.load(System.getProperties());
            return this;
        });
    }

    public boolean getBoolean(String key, boolean defValue) {
        String val = this.properties.getProperty(key, Boolean.toString(defValue));
        return Boolean.parseBoolean(val);
    }

    public int getInt(String key, int defValue) {
        String val = this.properties.getProperty(key, Integer.toString(defValue));
        if (val == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private Integer getLevelInt(String levelSegment, String levelStr) {
        String levelName;
        if (levelStr == null) {
            return null;
        }
        switch (levelName = levelStr.trim().toUpperCase(Locale.ENGLISH)) {
            case "ALL": {
                return -1;
            }
            case "TRACE": {
                return Level.TRACE.toInt();
            }
            case "DEBUG": {
                return Level.DEBUG.toInt();
            }
            case "INFO": {
                return Level.INFO.toInt();
            }
            case "WARN": {
                return Level.WARN.toInt();
            }
            case "ERROR": {
                return Level.ERROR.toInt();
            }
            case "OFF": {
                return 999;
            }
        }
        System.err.println("Unknown JettyLogger/Slf4J Level [" + levelSegment + "]=[" + levelName + "], expecting only [ALL, TRACE, DEBUG, INFO, WARN, ERROR, OFF] as values.");
        return null;
    }

    private URL getResource(ClassLoader loader, String resourceName) {
        if (loader == null) {
            return ClassLoader.getSystemResource(resourceName);
        }
        return loader.getResource(resourceName);
    }

    private void load(Properties props) {
        if (props == null) {
            return;
        }
        for (String name : props.stringPropertyNames()) {
            String val;
            if (!name.startsWith("org.eclipse.jetty.logging.") && !name.endsWith(SUFFIX_LEVEL) && !name.endsWith(SUFFIX_STACKS) || (val = props.getProperty(name)) == null) continue;
            this.properties.setProperty(name, val);
        }
    }

    private Properties readProperties(ClassLoader loader, String resourceName) {
        Properties properties;
        block9: {
            URL propsUrl = this.getResource(loader, resourceName);
            if (propsUrl == null) {
                return null;
            }
            InputStream in = propsUrl.openStream();
            try {
                Properties p = new Properties();
                p.load(in);
                properties = p;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    System.err.println("[WARN] Error loading logging config: " + propsUrl);
                    e.printStackTrace();
                    return null;
                }
            }
            in.close();
        }
        return properties;
    }

    private <T> T walkParentLoggerNames(String startName, Function<String, T> nameFunction) {
        String nameSegment = startName;
        while (nameSegment != null && nameSegment.length() > 0) {
            T ret = nameFunction.apply(nameSegment);
            if (ret != null) {
                return ret;
            }
            int idx = nameSegment.lastIndexOf(46);
            if (idx >= 0) {
                nameSegment = nameSegment.substring(0, idx);
                continue;
            }
            nameSegment = null;
        }
        return null;
    }
}

