/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import java.util.Objects;
import org.eclipse.jetty.logging.JettyAppender;
import org.eclipse.jetty.logging.JettyLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.spi.LocationAwareLogger;

public class JettyLogger
implements LocationAwareLogger,
Logger {
    public static final int OFF = 999;
    public static final int ALL = -1;
    private final JettyLoggerFactory factory;
    private final String name;
    private final String condensedName;
    private final JettyAppender appender;
    private int level;
    private boolean hideStacks = false;

    public JettyLogger(JettyLoggerFactory factory, String name, JettyAppender appender) {
        this(factory, name, appender, Level.INFO.toInt(), false);
    }

    public JettyLogger(JettyLoggerFactory factory, String name, JettyAppender appender, int level, boolean hideStacks) {
        this.factory = factory;
        this.name = name;
        this.condensedName = JettyLoggerFactory.condensePackageString(name);
        this.appender = appender;
        this.level = level;
        this.hideStacks = hideStacks;
    }

    @Override
    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.emit(Level.DEBUG, msg);
        }
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.emit(Level.DEBUG, format, arg);
        }
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.emit(Level.DEBUG, format, arg1, arg2);
        }
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.emit(Level.DEBUG, format, arguments);
        }
    }

    @Override
    public void debug(String msg, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.emit(Level.DEBUG, msg, throwable);
        }
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    @Override
    public void debug(Marker marker, String msg) {
        this.debug(msg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        this.debug(format, arg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(format, arg1, arg2);
    }

    @Override
    public void debug(Marker marker, String format, Object ... arguments) {
        this.debug(format, arguments);
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t) {
        this.debug(msg, t);
    }

    @Override
    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.emit(Level.ERROR, msg);
        }
    }

    @Override
    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.emit(Level.ERROR, format, arg);
        }
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.emit(Level.ERROR, format, arg1, arg2);
        }
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.emit(Level.ERROR, format, arguments);
        }
    }

    @Override
    public void error(String msg, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.emit(Level.ERROR, msg, throwable);
        }
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    @Override
    public void error(Marker marker, String msg) {
        this.error(msg);
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        this.error(format, arg);
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(format, arg1, arg2);
    }

    @Override
    public void error(Marker marker, String format, Object ... arguments) {
        this.error(format, arguments);
    }

    @Override
    public void error(Marker marker, String msg, Throwable t) {
        this.error(msg, t);
    }

    public JettyAppender getAppender() {
        return this.appender;
    }

    @Override
    public void log(Marker marker, String fqcn, int levelInt, String message, Object[] argArray, Throwable throwable) {
        if (this.level <= levelInt) {
            long timestamp = System.currentTimeMillis();
            String threadName = Thread.currentThread().getName();
            this.getAppender().emit(this, JettyLogger.intToLevel(levelInt), timestamp, threadName, throwable, message, argArray);
        }
    }

    public void log(LoggingEvent event) {
        this.getAppender().emit(this, event.getLevel(), event.getTimeStamp(), event.getThreadName(), event.getThrowable(), event.getMessage(), event.getArgumentArray());
    }

    public String getCondensedName() {
        return this.condensedName;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        Objects.requireNonNull(level, "Level");
        this.setLevel(level.toInt());
    }

    public void setLevel(int lvlInt) {
        this.level = lvlInt;
        this.factory.walkChildLoggers(this.getName(), logger -> logger.setLevel(lvlInt));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.emit(Level.INFO, msg);
        }
    }

    @Override
    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.emit(Level.INFO, format, arg);
        }
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.emit(Level.INFO, format, arg1, arg2);
        }
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.emit(Level.INFO, format, arguments);
        }
    }

    @Override
    public void info(String msg, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.emit(Level.INFO, msg, throwable);
        }
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    @Override
    public void info(Marker marker, String msg) {
        this.info(msg);
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        this.info(format, arg);
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(format, arg1, arg2);
    }

    @Override
    public void info(Marker marker, String format, Object ... arguments) {
        this.info(format, arguments);
    }

    @Override
    public void info(Marker marker, String msg, Throwable t) {
        this.info(msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level <= Level.DEBUG.toInt();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.level <= Level.ERROR.toInt();
    }

    public boolean isHideStacks() {
        return this.hideStacks;
    }

    public void setHideStacks(boolean hideStacks) {
        this.hideStacks = hideStacks;
        this.factory.walkChildLoggers(this.getName(), logger -> logger.setHideStacks(hideStacks));
    }

    @Override
    public boolean isInfoEnabled() {
        return this.level <= Level.INFO.toInt();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.level <= Level.TRACE.toInt();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.level <= Level.WARN.toInt();
    }

    @Override
    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.emit(Level.TRACE, msg);
        }
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.emit(Level.TRACE, format, arg);
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.emit(Level.TRACE, format, arg1, arg2);
        }
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.emit(Level.TRACE, format, arguments);
        }
    }

    @Override
    public void trace(String msg, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.emit(Level.TRACE, msg, throwable);
        }
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    @Override
    public void trace(Marker marker, String msg) {
        this.trace(msg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        this.trace(format, arg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.trace(format, arg1, arg2);
    }

    @Override
    public void trace(Marker marker, String format, Object ... argArray) {
        this.trace(format, argArray);
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t) {
        this.trace(msg, t);
    }

    @Override
    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.emit(Level.WARN, msg);
        }
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.emit(Level.WARN, format, arg);
        }
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.emit(Level.WARN, format, arguments);
        }
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.emit(Level.WARN, format, arg1, arg2);
        }
    }

    @Override
    public void warn(String msg, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.emit(Level.WARN, msg, throwable);
        }
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    @Override
    public void warn(Marker marker, String msg) {
        this.warn(msg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        this.warn(format, arg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(format, arg1, arg2);
    }

    @Override
    public void warn(Marker marker, String format, Object ... arguments) {
        this.warn(format, arguments);
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t) {
        this.warn(msg, t);
    }

    private void emit(Level level, String msg) {
        long timestamp = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        this.getAppender().emit(this, level, timestamp, threadName, null, msg, new Object[0]);
    }

    private void emit(Level level, String format, Object arg) {
        long timestamp = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        if (arg instanceof Throwable) {
            this.getAppender().emit(this, level, timestamp, threadName, (Throwable)arg, format, new Object[0]);
        } else {
            this.getAppender().emit(this, level, timestamp, threadName, null, format, arg);
        }
    }

    private void emit(Level level, String format, Object arg1, Object arg2) {
        long timestamp = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        if (arg2 instanceof Throwable) {
            this.getAppender().emit(this, level, timestamp, threadName, (Throwable)arg2, format, arg1);
        } else {
            this.getAppender().emit(this, level, timestamp, threadName, null, format, arg1, arg2);
        }
    }

    private void emit(Level level, String format, Object ... arguments) {
        long timestamp = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        this.getAppender().emit(this, level, timestamp, threadName, null, format, arguments);
    }

    private void emit(Level level, String msg, Throwable throwable) {
        long timestamp = System.currentTimeMillis();
        String threadName = Thread.currentThread().getName();
        this.getAppender().emit(this, level, timestamp, threadName, throwable, msg, new Object[0]);
    }

    public static Level intToLevel(int level) {
        if (level >= 999) {
            return Level.ERROR;
        }
        if (level >= Level.ERROR.toInt()) {
            return Level.ERROR;
        }
        if (level >= Level.WARN.toInt()) {
            return Level.WARN;
        }
        if (level >= Level.INFO.toInt()) {
            return Level.INFO;
        }
        if (level >= Level.DEBUG.toInt()) {
            return Level.DEBUG;
        }
        if (level >= Level.TRACE.toInt()) {
            return Level.TRACE;
        }
        return Level.TRACE;
    }

    public static String levelToString(int level) {
        if (level >= 999) {
            return "OFF";
        }
        if (level >= Level.ERROR.toInt()) {
            return "ERROR";
        }
        if (level >= Level.WARN.toInt()) {
            return "WARN";
        }
        if (level >= Level.INFO.toInt()) {
            return "INFO";
        }
        if (level >= Level.DEBUG.toInt()) {
            return "DEBUG";
        }
        if (level >= Level.TRACE.toInt()) {
            return "TRACE";
        }
        return "OFF";
    }

    public String toString() {
        return String.format("%s:%s:LEVEL=%s", JettyLogger.class.getSimpleName(), this.name, JettyLogger.levelToString(this.level));
    }
}

