/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.LeakDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeakTrackingConnectionPool
extends DuplexConnectionPool {
    private static final Logger LOG = LoggerFactory.getLogger(LeakTrackingConnectionPool.class);
    private final LeakDetector<Connection> leakDetector = new LeakDetector<Connection>(){

        @Override
        protected void leaked(LeakDetector.LeakInfo leakInfo) {
            LeakTrackingConnectionPool.this.leaked(leakInfo);
        }
    };

    public LeakTrackingConnectionPool(Destination destination, int maxConnections, Callback requester) {
        super(destination, maxConnections, requester);
        this.start();
    }

    private void start() {
        try {
            this.leakDetector.start();
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    public void close() {
        this.stop();
        super.close();
    }

    private void stop() {
        try {
            this.leakDetector.stop();
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    protected void acquired(Connection connection) {
        if (!this.leakDetector.acquired(connection)) {
            LOG.info("Connection {}@{} not tracked", (Object)connection, (Object)this.leakDetector.id(connection));
        }
    }

    @Override
    protected void released(Connection connection) {
        if (!this.leakDetector.released(connection)) {
            LOG.info("Connection {}@{} released but not acquired", (Object)connection, (Object)this.leakDetector.id(connection));
        }
    }

    protected void leaked(LeakDetector.LeakInfo leakInfo) {
        LOG.info("Connection " + leakInfo.getResourceDescription() + " leaked at:", leakInfo.getStackFrames());
    }
}

