/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.http.QuotedCSVParser;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.websocket.core.Behavior;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.internal.ExtensionStack;

public class Negotiation {
    private final Request baseRequest;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final List<ExtensionConfig> offeredExtensions;
    private final List<String> offeredSubprotocols;
    private final WebSocketComponents components;
    private final String version;
    private final Boolean upgrade;
    private final String key;
    private List<ExtensionConfig> negotiatedExtensions;
    private String subprotocol;
    private ExtensionStack extensionStack;

    public Negotiation(Request baseRequest, HttpServletRequest request, HttpServletResponse response, WebSocketComponents components) throws BadMessageException {
        this.baseRequest = baseRequest;
        this.request = request;
        this.response = response;
        this.components = components;
        Boolean upgrade = null;
        String key = null;
        String version = null;
        QuotedCSV connectionCSVs = null;
        QuotedCSVParser extensions = null;
        QuotedCSVParser subprotocols = null;
        try {
            for (HttpField field : baseRequest.getHttpFields()) {
                if (field.getHeader() == null) continue;
                switch (field.getHeader()) {
                    case UPGRADE: {
                        if (upgrade != null || !"websocket".equalsIgnoreCase(field.getValue())) break;
                        upgrade = Boolean.TRUE;
                        break;
                    }
                    case CONNECTION: {
                        if (connectionCSVs == null) {
                            connectionCSVs = new QuotedCSV(new String[0]);
                        }
                        connectionCSVs.addValue(field.getValue());
                        break;
                    }
                    case SEC_WEBSOCKET_KEY: {
                        key = field.getValue();
                        break;
                    }
                    case SEC_WEBSOCKET_VERSION: {
                        version = field.getValue();
                        break;
                    }
                    case SEC_WEBSOCKET_EXTENSIONS: {
                        if (extensions == null) {
                            extensions = new QuotedCSV(field.getValue());
                            break;
                        }
                        extensions.addValue(field.getValue());
                        break;
                    }
                    case SEC_WEBSOCKET_SUBPROTOCOL: {
                        if (subprotocols == null) {
                            subprotocols = new QuotedCSV(field.getValue());
                            break;
                        }
                        subprotocols.addValue(field.getValue());
                        break;
                    }
                }
            }
            this.version = version;
            this.key = key;
            this.upgrade = upgrade != null && connectionCSVs != null && connectionCSVs.getValues().stream().anyMatch(s -> s.equalsIgnoreCase("Upgrade"));
            Set<String> available = components.getExtensionRegistry().getAvailableExtensionNames();
            this.offeredExtensions = extensions == null ? Collections.emptyList() : ((QuotedCSV)extensions).getValues().stream().map(ExtensionConfig::parse).filter(ec -> available.contains(ec.getName().toLowerCase()) && !ec.getName().startsWith("@")).collect(Collectors.toList());
            this.offeredExtensions.forEach(ExtensionConfig::removeInternalParameters);
            this.offeredSubprotocols = subprotocols == null ? Collections.emptyList() : ((QuotedCSV)subprotocols).getValues();
            this.negotiatedExtensions = new ArrayList<ExtensionConfig>();
            for (ExtensionConfig config : this.offeredExtensions) {
                long matches = this.negotiatedExtensions.stream().filter(negotiatedConfig -> negotiatedConfig.getName().equals(config.getName())).count();
                if (matches != 0L) continue;
                this.negotiatedExtensions.add(new ExtensionConfig(config));
            }
        }
        catch (Throwable t) {
            throw new BadMessageException("Invalid Handshake Request", t);
        }
    }

    public String getKey() {
        return this.key;
    }

    public List<ExtensionConfig> getOfferedExtensions() {
        return this.offeredExtensions;
    }

    public void setNegotiatedExtensions(List<ExtensionConfig> extensions) {
        if (extensions == this.offeredExtensions) {
            return;
        }
        this.negotiatedExtensions = extensions == null ? null : new ArrayList<ExtensionConfig>(extensions);
        this.extensionStack = null;
    }

    public List<ExtensionConfig> getNegotiatedExtensions() {
        return this.negotiatedExtensions;
    }

    public List<String> getOfferedSubprotocols() {
        return this.offeredSubprotocols;
    }

    public Request getBaseRequest() {
        return this.baseRequest;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setSubprotocol(String subprotocol) {
        this.subprotocol = subprotocol;
        this.response.setHeader(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL.asString(), subprotocol);
    }

    public String getSubprotocol() {
        return this.subprotocol;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public ExtensionStack getExtensionStack() {
        if (this.extensionStack == null) {
            this.extensionStack = new ExtensionStack(this.components, Behavior.SERVER);
            this.extensionStack.negotiate(this.offeredExtensions, this.negotiatedExtensions);
            this.negotiatedExtensions = this.extensionStack.getNegotiatedExtensions();
            if (this.extensionStack.hasNegotiatedExtensions()) {
                this.baseRequest.getResponse().setHeader(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, ExtensionConfig.toHeaderValue(this.negotiatedExtensions));
            } else {
                this.baseRequest.getResponse().setHeader(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, null);
            }
        }
        return this.extensionStack;
    }

    public String toString() {
        return String.format("Negotiation@%x{uri=%s,oe=%s,op=%s}", this.hashCode(), this.getRequest().getRequestURI(), this.getOfferedExtensions(), this.getOfferedSubprotocols());
    }
}

