/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.internal;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.core.Frame;

public class Generator {
    public static final int MAX_HEADER_LENGTH = 28;
    private static byte[] mask = new byte[]{0, -16, 15, -1};
    private final ByteBufferPool bufferPool;
    private final boolean readOnly;

    public static void putMask(ByteBuffer buffer) {
        buffer.put(mask, 0, mask.length);
    }

    public static void putPayload(ByteBuffer buffer, byte[] payload) {
        int len = payload.length;
        for (int i2 = 0; i2 < len; ++i2) {
            buffer.put((byte)(payload[i2] ^ mask[i2 % 4]));
        }
    }

    public Generator(ByteBufferPool bufferPool) {
        this(bufferPool, false);
    }

    public Generator(ByteBufferPool bufferPool, boolean readOnly) {
        this.bufferPool = bufferPool;
        this.readOnly = readOnly;
    }

    public ByteBuffer generateHeaderBytes(Frame frame) {
        ByteBuffer buffer = this.bufferPool.acquire(28, false);
        BufferUtil.clearToFill(buffer);
        this.generateHeaderBytes(frame, buffer);
        BufferUtil.flipToFlush(buffer, 0);
        return buffer;
    }

    public void generateHeaderBytes(Frame frame, ByteBuffer buffer) {
        byte b = 0;
        if (frame.isFin()) {
            b = (byte)(b | 0x80);
        }
        if (frame.isRsv1()) {
            b = (byte)(b | 0x40);
        }
        if (frame.isRsv2()) {
            b = (byte)(b | 0x20);
        }
        if (frame.isRsv3()) {
            b = (byte)(b | 0x10);
        }
        byte opcode = frame.getOpCode();
        b = (byte)(b | opcode & 0xF);
        buffer.put(b);
        b = frame.isMasked() ? (byte)-128 : 0;
        int payloadLength = frame.getPayloadLength();
        if (payloadLength > 65535) {
            b = (byte)(b | 0x7F);
            buffer.put(b);
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)(payloadLength >> 24 & 0xFF));
            buffer.put((byte)(payloadLength >> 16 & 0xFF));
            buffer.put((byte)(payloadLength >> 8 & 0xFF));
            buffer.put((byte)(payloadLength & 0xFF));
        } else if (payloadLength >= 126) {
            b = (byte)(b | 0x7E);
            buffer.put(b);
            buffer.put((byte)(payloadLength >> 8));
            buffer.put((byte)(payloadLength & 0xFF));
        } else {
            b = (byte)(b | payloadLength & 0x7F);
            buffer.put(b);
        }
        if (frame.isMasked() && !this.readOnly) {
            byte[] mask = frame.getMask();
            buffer.put(mask);
            int maskInt = 0;
            for (byte maskByte : mask) {
                maskInt = (maskInt << 8) + (maskByte & 0xFF);
            }
            ByteBuffer payload = frame.getPayload();
            if (payload != null && payload.remaining() > 0) {
                int remaining;
                int maskOffset = 0;
                int start = payload.position();
                int end = payload.limit();
                while ((remaining = end - start) > 0) {
                    if (remaining >= 4) {
                        payload.putInt(start, payload.getInt(start) ^ maskInt);
                        start += 4;
                        continue;
                    }
                    payload.put(start, (byte)(payload.get(start) ^ mask[maskOffset & 3]));
                    ++start;
                    ++maskOffset;
                }
            }
        }
    }

    public void generateWholeFrame(Frame frame, ByteBuffer buf) {
        this.generateHeaderBytes(frame, buf);
        if (frame.hasPayload()) {
            if (this.readOnly) {
                buf.put(frame.getPayload().slice());
            } else {
                buf.put(frame.getPayload());
            }
        }
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }
}

