/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.internal;

import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.AbstractExtension;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.internal.FragmentingFlusher;

public class FragmentExtension
extends AbstractExtension {
    private static final Logger LOG = Log.getLogger(FragmentExtension.class);
    private final FragmentingFlusher flusher;
    private final FrameHandler.Configuration configuration = new FrameHandler.ConfigurationHolder();

    public FragmentExtension() {
        this.flusher = new FragmentingFlusher(this.configuration){

            @Override
            void forwardFrame(Frame frame, Callback callback, boolean batch) {
                FragmentExtension.this.nextOutgoingFrame(frame, callback, batch);
            }
        };
    }

    @Override
    public String getName() {
        return "fragment";
    }

    @Override
    public void onFrame(Frame frame, Callback callback) {
        this.nextIncomingFrame(frame, callback);
    }

    @Override
    public void sendFrame(Frame frame, Callback callback, boolean batch) {
        this.flusher.sendFrame(frame, callback, batch);
    }

    @Override
    public void init(ExtensionConfig config, WebSocketComponents components) {
        super.init(config, components);
        int maxLength = config.getParameter("maxLength", -1);
        this.configuration.setMaxFrameSize(maxLength);
    }
}

