/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Optional;
import org.junit.jupiter.api.condition.DisabledIfEnvironmentVariable;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

class DisabledIfEnvironmentVariableCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled("@DisabledIfEnvironmentVariable is not present");

    DisabledIfEnvironmentVariableCondition() {
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional<DisabledIfEnvironmentVariable> optional = AnnotationUtils.findAnnotation(context.getElement(), DisabledIfEnvironmentVariable.class);
        if (!optional.isPresent()) {
            return ENABLED_BY_DEFAULT;
        }
        DisabledIfEnvironmentVariable annotation = optional.get();
        String name = annotation.named().trim();
        String regex = annotation.matches();
        Preconditions.notBlank(name, () -> "The 'named' attribute must not be blank in " + annotation);
        Preconditions.notBlank(regex, () -> "The 'matches' attribute must not be blank in " + annotation);
        String actual = this.getEnvironmentVariable(name);
        if (actual == null) {
            return ConditionEvaluationResult.enabled(String.format("Environment variable [%s] does not exist", name));
        }
        if (actual.matches(regex)) {
            return ConditionEvaluationResult.disabled(String.format("Environment variable [%s] with value [%s] matches regular expression [%s]", name, actual, regex));
        }
        return ConditionEvaluationResult.enabled(String.format("Environment variable [%s] with value [%s] does not match regular expression [%s]", name, actual, regex));
    }

    protected String getEnvironmentVariable(String name) {
        return System.getenv(name);
    }
}

