/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.servlet;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.time.Duration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.WebSocketExtensionRegistry;
import org.eclipse.jetty.websocket.servlet.FrameHandlerFactory;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketMapping;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public abstract class WebSocketServlet
extends HttpServlet {
    private static final Logger LOG = Log.getLogger(WebSocketServlet.class);
    private final CustomizedWebSocketServletFactory customizer = new CustomizedWebSocketServletFactory();
    private WebSocketMapping mapping;
    private WebSocketComponents components;

    protected abstract void configure(WebSocketServletFactory var1);

    protected abstract FrameHandlerFactory getFactory();

    @Override
    public void init() throws ServletException {
        try {
            String autoFragment;
            ServletContext servletContext = this.getServletContext();
            this.components = WebSocketComponents.ensureWebSocketComponents(servletContext);
            this.mapping = new WebSocketMapping(this.components);
            String max = this.getInitParameter("idleTimeout");
            if (max == null && (max = this.getInitParameter("maxIdleTime")) != null) {
                LOG.warn("'maxIdleTime' init param is deprecated, use 'idleTimeout' instead", new Object[0]);
            }
            if (max != null) {
                this.customizer.setIdleTimeout(Duration.ofMillis(Long.parseLong(max)));
            }
            if ((max = this.getInitParameter("maxTextMessageSize")) != null) {
                this.customizer.setMaxTextMessageSize(Long.parseLong(max));
            }
            if ((max = this.getInitParameter("maxBinaryMessageSize")) != null) {
                this.customizer.setMaxBinaryMessageSize(Long.parseLong(max));
            }
            if ((max = this.getInitParameter("inputBufferSize")) != null) {
                this.customizer.setInputBufferSize(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("outputBufferSize")) != null) {
                this.customizer.setOutputBufferSize(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("maxFrameSize")) == null) {
                max = this.getInitParameter("maxAllowedFrameSize");
            }
            if (max != null) {
                this.customizer.setMaxFrameSize(Long.parseLong(max));
            }
            if ((autoFragment = this.getInitParameter("autoFragment")) != null) {
                this.customizer.setAutoFragment(Boolean.parseBoolean(autoFragment));
            }
            this.configure(this.customizer);
        }
        catch (Throwable x) {
            throw new ServletException(x);
        }
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.mapping.upgrade(req, resp, null)) {
            return;
        }
        if (resp.isCommitted()) {
            return;
        }
        super.service(req, resp);
    }

    private class CustomizedWebSocketServletFactory
    extends FrameHandler.ConfigurationCustomizer
    implements WebSocketServletFactory {
        private CustomizedWebSocketServletFactory() {
        }

        @Override
        public WebSocketExtensionRegistry getExtensionRegistry() {
            return WebSocketServlet.this.components.getExtensionRegistry();
        }

        @Override
        public void addMapping(String pathSpec, WebSocketCreator creator) {
            this.addMapping(WebSocketMapping.parsePathSpec(pathSpec), creator);
        }

        @Override
        public void addMapping(PathSpec pathSpec, WebSocketCreator creator) {
            WebSocketServlet.this.mapping.addMapping(pathSpec, creator, WebSocketServlet.this.getFactory(), this);
        }

        @Override
        public void register(Class<?> endpointClass) {
            Constructor<?> constructor;
            try {
                constructor = endpointClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            WebSocketCreator creator = (req, resp) -> {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return null;
                }
            };
            this.addMapping("/", creator);
        }

        @Override
        public void setCreator(WebSocketCreator creator) {
            this.addMapping("/", creator);
        }

        @Override
        public WebSocketCreator getMapping(PathSpec pathSpec) {
            return WebSocketServlet.this.mapping.getMapping(pathSpec);
        }

        @Override
        public WebSocketCreator getMatch(String target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeMapping(PathSpec pathSpec) {
            return WebSocketServlet.this.mapping.removeMapping(pathSpec);
        }

        @Override
        public PathSpec parsePathSpec(String pathSpec) {
            return WebSocketMapping.parsePathSpec(pathSpec);
        }
    }
}

