/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.servlet;

import java.io.IOException;
import java.util.function.Consumer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.pathmap.MappedResource;
import org.eclipse.jetty.http.pathmap.PathMappings;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.RegexPathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.WebSocketException;
import org.eclipse.jetty.websocket.core.server.Handshaker;
import org.eclipse.jetty.websocket.core.server.Negotiation;
import org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;
import org.eclipse.jetty.websocket.servlet.FrameHandlerFactory;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;

public class WebSocketMapping
implements Dumpable,
LifeCycle.Listener {
    private static final Logger LOG = Log.getLogger(WebSocketMapping.class);
    public static final String DEFAULT_KEY = "org.eclipse.jetty.websocket.servlet.WebSocketMapping";
    private final PathMappings<Negotiator> mappings = new PathMappings();
    private final WebSocketComponents components;
    private final Handshaker handshaker = Handshaker.newInstance();

    public static WebSocketMapping getMapping(ServletContext servletContext, String mappingKey) {
        Object mappingObject = servletContext.getAttribute(mappingKey);
        if (mappingObject != null) {
            if (WebSocketMapping.class.isInstance(mappingObject)) {
                return (WebSocketMapping)mappingObject;
            }
            throw new IllegalStateException(String.format("ContextHandler attribute %s is not of type WebSocketMapping: {%s}", mappingKey, mappingObject.toString()));
        }
        return null;
    }

    public WebSocketCreator getMapping(PathSpec pathSpec) {
        Negotiator cn = this.mappings.get(pathSpec);
        return cn == null ? null : cn.getWebSocketCreator();
    }

    public static WebSocketMapping ensureMapping(ServletContext servletContext, String mappingKey) {
        WebSocketMapping mapping = WebSocketMapping.getMapping(servletContext, mappingKey);
        if (mapping == null) {
            mapping = new WebSocketMapping(WebSocketComponents.ensureWebSocketComponents(servletContext));
            servletContext.setAttribute(mappingKey, mapping);
        }
        return mapping;
    }

    public static PathSpec parsePathSpec(String rawSpec) {
        if (rawSpec.charAt(0) == '/' || rawSpec.startsWith("*.") || rawSpec.startsWith("servlet|")) {
            return new ServletPathSpec(rawSpec);
        }
        if (rawSpec.charAt(0) == '^' || rawSpec.startsWith("regex|")) {
            return new RegexPathSpec(rawSpec);
        }
        if (rawSpec.startsWith("uri-template|")) {
            return new UriTemplatePathSpec(rawSpec.substring("uri-template|".length()));
        }
        throw new IllegalArgumentException("Unrecognized path spec syntax [" + rawSpec + "]");
    }

    public WebSocketMapping() {
        this(new WebSocketComponents());
    }

    public WebSocketMapping(WebSocketComponents components) {
        this.components = components;
    }

    @Override
    public void lifeCycleStopping(LifeCycle context) {
        ContextHandler contextHandler = (ContextHandler)context;
        WebSocketMapping mapping = contextHandler.getBean(WebSocketMapping.class);
        if (mapping == this) {
            contextHandler.removeBean(mapping);
            this.mappings.reset();
        }
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, this.mappings);
    }

    public void addMapping(PathSpec pathSpec, WebSocketCreator creator, FrameHandlerFactory factory, FrameHandler.Customizer customizer) throws WebSocketException {
        this.mappings.put(pathSpec, new Negotiator(creator, factory, customizer));
    }

    public boolean removeMapping(PathSpec pathSpec) {
        return this.mappings.remove(pathSpec);
    }

    public WebSocketNegotiator getMatchedNegotiator(String target, Consumer<PathSpec> pathSpecConsumer) {
        MappedResource<Negotiator> mapping = this.mappings.getMatch(target);
        if (mapping == null) {
            return null;
        }
        pathSpecConsumer.accept(mapping.getPathSpec());
        return mapping.getResource();
    }

    public boolean upgrade(HttpServletRequest request, HttpServletResponse response, FrameHandler.Customizer defaultCustomizer) throws IOException {
        WebSocketNegotiator negotiator;
        Object target = request.getServletPath();
        if (request.getPathInfo() != null) {
            target = (String)target + request.getPathInfo();
        }
        if ((negotiator = this.getMatchedNegotiator((String)target, pathSpec -> request.setAttribute(PathSpec.class.getName(), pathSpec))) == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("WebSocket Negotiated detected on {} for endpoint {}", target, negotiator);
        }
        return this.handshaker.upgradeRequest(negotiator, request, response, defaultCustomizer);
    }

    private class Negotiator
    extends WebSocketNegotiator.AbstractNegotiator {
        private final WebSocketCreator creator;
        private final FrameHandlerFactory factory;

        public Negotiator(WebSocketCreator creator, FrameHandlerFactory factory, FrameHandler.Customizer customizer) {
            super(WebSocketMapping.this.components, customizer);
            this.creator = creator;
            this.factory = factory;
        }

        public WebSocketCreator getWebSocketCreator() {
            return this.creator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FrameHandler negotiate(Negotiation negotiation) throws IOException {
            ServletContext servletContext = negotiation.getRequest().getServletContext();
            if (servletContext == null) {
                throw new IllegalStateException("null servletContext from request");
            }
            ClassLoader loader = servletContext.getClassLoader();
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(loader);
                ServletUpgradeRequest upgradeRequest = new ServletUpgradeRequest(negotiation);
                ServletUpgradeResponse upgradeResponse = new ServletUpgradeResponse(negotiation);
                Object websocketPojo = this.creator.createWebSocket(upgradeRequest, upgradeResponse);
                if (upgradeResponse.isCommitted()) {
                    FrameHandler frameHandler = null;
                    return frameHandler;
                }
                if (websocketPojo == null) {
                    upgradeResponse.sendError(503, "WebSocket Endpoint Creation Refused");
                    FrameHandler frameHandler = null;
                    return frameHandler;
                }
                FrameHandler frameHandler = this.factory.newFrameHandler(websocketPojo, upgradeRequest, upgradeResponse);
                if (frameHandler != null) {
                    FrameHandler frameHandler2 = frameHandler;
                    return frameHandler2;
                }
                FrameHandler frameHandler3 = null;
                return frameHandler3;
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }

        public String toString() {
            return String.format("%s@%x{%s,%s,%s}", this.getClass().getSimpleName(), this.hashCode(), this.creator, this.factory, this.getCustomizer());
        }
    }
}

