/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.config;

import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppConfiguration;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class JettyWebSocketConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(JettyWebSocketConfiguration.class);

    public JettyWebSocketConfiguration() {
        this.addDependencies(WebXmlConfiguration.class, MetaInfConfiguration.class, WebInfConfiguration.class, FragmentConfiguration.class);
        if (this.isAvailable("org.eclipse.jetty.osgi.annotations.AnnotationConfiguration")) {
            this.addDependents("org.eclipse.jetty.osgi.annotations.AnnotationConfiguration", WebAppConfiguration.class.getName());
        } else if (this.isAvailable("org.eclipse.jetty.annotations.AnnotationConfiguration")) {
            this.addDependents("org.eclipse.jetty.annotations.AnnotationConfiguration", WebAppConfiguration.class.getName());
        } else {
            throw new RuntimeException("Unable to add AnnotationConfiguration dependent (not present in classpath)");
        }
        this.protectAndExpose("org.eclipse.jetty.websocket.api.", "org.eclipse.jetty.websocket.server.");
        this.hide("org.eclipse.jetty.server.internal.", "org.eclipse.jetty.server.config.");
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable("org.eclipse.jetty.websocket.common.JettyWebSocketFrame");
    }

    private boolean isAvailable(String classname) {
        try {
            return Loader.loadClass(classname) != null;
        }
        catch (Throwable e) {
            LOG.ignore(e);
            return false;
        }
    }
}

