/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server.internal;

import java.io.IOException;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.core.Behavior;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.WebSocketConstants;
import org.eclipse.jetty.websocket.core.WebSocketException;
import org.eclipse.jetty.websocket.core.internal.ExtensionStack;
import org.eclipse.jetty.websocket.core.internal.Negotiated;
import org.eclipse.jetty.websocket.core.internal.WebSocketConnection;
import org.eclipse.jetty.websocket.core.internal.WebSocketCore;
import org.eclipse.jetty.websocket.core.internal.WebSocketCoreSession;
import org.eclipse.jetty.websocket.core.server.Handshaker;
import org.eclipse.jetty.websocket.core.server.Negotiation;
import org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;

public final class RFC6455Handshaker
implements Handshaker {
    static final Logger LOG = Log.getLogger(RFC6455Handshaker.class);
    private static final HttpField UPGRADE_WEBSOCKET = new PreEncodedHttpField(HttpHeader.UPGRADE, "WebSocket");
    private static final HttpField CONNECTION_UPGRADE = new PreEncodedHttpField(HttpHeader.CONNECTION, HttpHeader.UPGRADE.asString());
    private static final HttpField SERVER_VERSION = new PreEncodedHttpField(HttpHeader.SERVER, HttpConfiguration.SERVER_VERSION);

    @Override
    public boolean upgradeRequest(WebSocketNegotiator negotiator, HttpServletRequest request, HttpServletResponse response, FrameHandler.Customizer defaultCustomizer) throws IOException {
        Request baseRequest = Request.getBaseRequest(request);
        HttpChannel httpChannel = baseRequest.getHttpChannel();
        Connector connector = httpChannel.getConnector();
        if (negotiator == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded: no WebSocketNegotiator {}", baseRequest);
            }
            return false;
        }
        if (!HttpMethod.GET.is(request.getMethod())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded method!=GET {}", baseRequest);
            }
            return false;
        }
        if (!HttpVersion.HTTP_1_1.equals((Object)baseRequest.getHttpVersion())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded version!=1.1 {}", baseRequest);
            }
            return false;
        }
        ByteBufferPool pool = negotiator.getByteBufferPool();
        if (pool == null) {
            pool = baseRequest.getHttpChannel().getConnector().getByteBufferPool();
        }
        Negotiation negotiation = new Negotiation(baseRequest, request, response, new WebSocketComponents());
        if (LOG.isDebugEnabled()) {
            LOG.debug("negotiation {}", negotiation);
        }
        if (!negotiation.isUpgrade()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded: no upgrade header or connection upgrade", baseRequest);
            }
            return false;
        }
        if (!WebSocketConstants.SPEC_VERSION_STRING.equals(negotiation.getVersion())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded: unsupported version {} {}", negotiation.getVersion(), baseRequest);
            }
            return false;
        }
        if (negotiation.getKey() == null) {
            throw new BadMessageException("Missing request header 'Sec-WebSocket-Key'");
        }
        FrameHandler handler = negotiator.negotiate(negotiation);
        if (LOG.isDebugEnabled()) {
            LOG.debug("negotiated handler {}", handler);
        }
        if (response.isCommitted()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded: response committed {}", baseRequest);
            }
            baseRequest.setHandled(true);
            return false;
        }
        if (response.getStatus() > 200) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded: error sent {} {}", response.getStatus(), baseRequest);
            }
            response.flushBuffer();
            baseRequest.setHandled(true);
            return false;
        }
        if (handler == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded: no frame handler provided {}", baseRequest);
            }
            return false;
        }
        String subprotocol = negotiation.getSubprotocol();
        if (subprotocol != null) {
            if (!negotiation.getOfferedSubprotocols().contains(subprotocol)) {
                throw new WebSocketException("not upgraded: selected a subprotocol not present in offered subprotocols");
            }
        } else if (!negotiation.getOfferedSubprotocols().isEmpty()) {
            throw new WebSocketException("not upgraded: no subprotocol selected from offered subprotocols");
        }
        for (ExtensionConfig config : negotiation.getNegotiatedExtensions()) {
            if (config.getName().startsWith("@")) continue;
            long matches = negotiation.getOfferedExtensions().stream().filter(c -> config.getName().equalsIgnoreCase(c.getName())).count();
            if (matches < 1L) {
                throw new WebSocketException("Upgrade failed: negotiated extension not requested");
            }
            matches = negotiation.getNegotiatedExtensions().stream().filter(c -> config.getName().equalsIgnoreCase(c.getName())).count();
            if (matches <= 1L) continue;
            throw new WebSocketException("Upgrade failed: multiple negotiated extensions of the same name");
        }
        ExtensionStack extensionStack = negotiation.getExtensionStack();
        Negotiated negotiated = new Negotiated(baseRequest.getHttpURI().toURI(), subprotocol, baseRequest.isSecure(), extensionStack, WebSocketConstants.SPEC_VERSION_STRING);
        WebSocketCoreSession coreSession = this.newWebSocketCoreSession(handler, negotiated);
        if (defaultCustomizer != null) {
            defaultCustomizer.customize(coreSession);
        }
        negotiator.customize(coreSession);
        if (LOG.isDebugEnabled()) {
            LOG.debug("session {}", coreSession);
        }
        WebSocketConnection connection = this.newWebSocketConnection(httpChannel.getEndPoint(), connector.getExecutor(), connector.getScheduler(), connector.getByteBufferPool(), coreSession);
        if (LOG.isDebugEnabled()) {
            LOG.debug("connection {}", connection);
        }
        if (connection == null) {
            throw new WebSocketException("not upgraded: no connection");
        }
        for (Connection.Listener listener : connector.getBeans(Connection.Listener.class)) {
            connection.addListener(listener);
        }
        coreSession.setWebSocketConnection(connection);
        Response baseResponse = baseRequest.getResponse();
        baseResponse.setStatus(101);
        baseResponse.getHttpFields().put(UPGRADE_WEBSOCKET);
        baseResponse.getHttpFields().put(CONNECTION_UPGRADE);
        baseResponse.getHttpFields().put(HttpHeader.SEC_WEBSOCKET_ACCEPT, WebSocketCore.hashKey(negotiation.getKey()));
        if (this.getSendServerVersion(connector)) {
            baseResponse.getHttpFields().put(SERVER_VERSION);
        }
        baseResponse.flushBuffer();
        baseRequest.setHandled(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("upgrade connection={} session={}", connection, coreSession);
        }
        baseRequest.setAttribute("org.eclipse.jetty.server.HttpConnection.UPGRADE", connection);
        return true;
    }

    protected WebSocketCoreSession newWebSocketCoreSession(FrameHandler handler, Negotiated negotiated) {
        return new WebSocketCoreSession(handler, Behavior.SERVER, negotiated);
    }

    protected WebSocketConnection newWebSocketConnection(EndPoint endPoint, Executor executor, Scheduler scheduler, ByteBufferPool byteBufferPool, WebSocketCoreSession coreSession) {
        return new WebSocketConnection(endPoint, executor, scheduler, byteBufferPool, coreSession);
    }

    private boolean getSendServerVersion(Connector connector) {
        HttpConfiguration httpConf;
        ConnectionFactory connFactory = connector.getConnectionFactory(HttpVersion.HTTP_1_1.asString());
        if (connFactory == null) {
            return false;
        }
        if (connFactory instanceof HttpConnectionFactory && (httpConf = ((HttpConnectionFactory)connFactory).getHttpConfiguration()) != null) {
            return httpConf.getSendServerVersion();
        }
        return false;
    }
}

