/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server;

import java.io.IOException;
import java.util.function.Function;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.WebSocketExtensionRegistry;
import org.eclipse.jetty.websocket.core.server.Negotiation;

public interface WebSocketNegotiator
extends FrameHandler.Customizer {
    public FrameHandler negotiate(Negotiation var1) throws IOException;

    public WebSocketExtensionRegistry getExtensionRegistry();

    public DecoratedObjectFactory getObjectFactory();

    public ByteBufferPool getByteBufferPool();

    public WebSocketComponents getWebSocketComponents();

    public static WebSocketNegotiator from(final Function<Negotiation, FrameHandler> negotiate) {
        return new AbstractNegotiator(){

            @Override
            public FrameHandler negotiate(Negotiation negotiation) {
                return (FrameHandler)negotiate.apply(negotiation);
            }
        };
    }

    public static WebSocketNegotiator from(final Function<Negotiation, FrameHandler> negotiate, FrameHandler.Customizer customizer) {
        return new AbstractNegotiator(null, customizer){

            @Override
            public FrameHandler negotiate(Negotiation negotiation) {
                return (FrameHandler)negotiate.apply(negotiation);
            }
        };
    }

    public static WebSocketNegotiator from(final Function<Negotiation, FrameHandler> negotiate, WebSocketComponents components, FrameHandler.Customizer customizer) {
        return new AbstractNegotiator(components, customizer){

            @Override
            public FrameHandler negotiate(Negotiation negotiation) {
                return (FrameHandler)negotiate.apply(negotiation);
            }
        };
    }

    public static abstract class AbstractNegotiator
    implements WebSocketNegotiator {
        final WebSocketComponents components;
        final FrameHandler.Customizer customizer;

        public AbstractNegotiator() {
            this(null, null);
        }

        public AbstractNegotiator(WebSocketComponents components, FrameHandler.Customizer customizer) {
            this.components = components == null ? new WebSocketComponents() : components;
            this.customizer = customizer;
        }

        @Override
        public void customize(FrameHandler.Configuration configurable) {
            if (this.customizer != null) {
                this.customizer.customize(configurable);
            }
        }

        @Override
        public WebSocketExtensionRegistry getExtensionRegistry() {
            return this.components.getExtensionRegistry();
        }

        @Override
        public DecoratedObjectFactory getObjectFactory() {
            return this.components.getObjectFactory();
        }

        @Override
        public ByteBufferPool getByteBufferPool() {
            return this.components.getBufferPool();
        }

        @Override
        public WebSocketComponents getWebSocketComponents() {
            return this.components;
        }

        public FrameHandler.Customizer getCustomizer() {
            return this.customizer;
        }
    }
}

