/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.internal.compress;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.websocket.core.MessageTooLargeException;

public class ByteAccumulator {
    private final List<byte[]> chunks = new ArrayList<byte[]>();
    private final int maxSize;
    private int length = 0;

    public ByteAccumulator(int maxOverallMessageSize) {
        this.maxSize = maxOverallMessageSize;
    }

    public void copyChunk(byte[] buf, int offset, int length) {
        if (this.length + length > this.maxSize) {
            throw new MessageTooLargeException(String.format("Decompressed Message [%,d b] is too large [max %,d b]", this.length + length, this.maxSize));
        }
        byte[] copy = new byte[length - offset];
        System.arraycopy(buf, offset, copy, 0, length);
        this.chunks.add(copy);
        this.length += length;
    }

    public int getLength() {
        return this.length;
    }

    public void transferTo(ByteBuffer bufferInFillMode) {
        if (bufferInFillMode.remaining() < this.length) {
            throw new IllegalArgumentException(String.format("Not enough space in ByteBuffer remaining [%d] for accumulated buffers length [%d]", bufferInFillMode.remaining(), this.length));
        }
        for (byte[] chunk : this.chunks) {
            bufferInFillMode.put(chunk, 0, chunk.length);
        }
    }
}

