/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.client;

import java.net.URL;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.websocket.core.client.HttpClientProvider;
import org.eclipse.jetty.xml.XmlConfiguration;

class XmlHttpClientProvider
implements HttpClientProvider {
    XmlHttpClientProvider() {
    }

    @Override
    public HttpClient newHttpClient() {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("jetty-websocket-httpclient.xml");
        if (resource == null) {
            return null;
        }
        try {
            XmlConfiguration configuration = new XmlConfiguration(Resource.newResource(resource));
            return (HttpClient)configuration.configure();
        }
        catch (Throwable t) {
            Log.getLogger(XmlHttpClientProvider.class).warn("Unable to load: " + resource, t);
            return null;
        }
    }
}

