/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.FrameHandler;

public class MessageOutputStream
extends OutputStream {
    private static final Logger LOG = Log.getLogger(MessageOutputStream.class);
    private final FrameHandler.CoreSession coreSession;
    private final ByteBufferPool bufferPool;
    private final SharedBlockingCallback blocker;
    private long frameCount;
    private long bytesSent;
    private Frame frame;
    private ByteBuffer buffer;
    private Callback callback;
    private boolean closed;

    public MessageOutputStream(FrameHandler.CoreSession coreSession, int bufferSize, ByteBufferPool bufferPool) {
        this.coreSession = coreSession;
        this.bufferPool = bufferPool;
        this.blocker = new SharedBlockingCallback();
        this.buffer = bufferPool.acquire(bufferSize, true);
        BufferUtil.flipToFill(this.buffer);
        this.frame = new Frame(2);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        try {
            this.send(bytes, off, len);
        }
        catch (Throwable x) {
            this.notifyFailure(x);
            throw x;
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.send(new byte[]{(byte)b}, 0, 1);
        }
        catch (Throwable x) {
            this.notifyFailure(x);
            throw x;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.flush(false);
        }
        catch (Throwable x) {
            this.notifyFailure(x);
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(boolean fin) throws IOException {
        MessageOutputStream messageOutputStream = this;
        synchronized (messageOutputStream) {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            this.closed = fin;
            BufferUtil.flipToFlush(this.buffer, 0);
            this.frame.setPayload(this.buffer);
            this.frame.setFin(fin);
            try (SharedBlockingCallback.Blocker b = this.blocker.acquire();){
                this.coreSession.sendFrame(this.frame, b, false);
                b.block();
                assert (this.buffer.remaining() == 0);
            }
            finally {
                BufferUtil.clearToFill(this.buffer);
            }
            ++this.frameCount;
            this.frame = new Frame(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(byte[] bytes, int offset, int length) throws IOException {
        MessageOutputStream messageOutputStream = this;
        synchronized (messageOutputStream) {
            int size;
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            int off = offset;
            int space = this.buffer.remaining();
            for (int remaining = length; remaining > 0; remaining -= size) {
                size = Math.min(space, remaining);
                this.buffer.put(bytes, off, size);
                off += size;
                space = this.buffer.remaining();
                if (space != 0) continue;
                this.flush(false);
                space = this.buffer.remaining();
            }
            this.bytesSent += (long)length;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush(true);
            this.bufferPool.release(this.buffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream closed, {} frames ({} bytes) sent", this.frameCount, this.bytesSent);
            }
            this.notifySuccess();
        }
        catch (Throwable x) {
            this.notifyFailure(x);
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(Callback callback) {
        MessageOutputStream messageOutputStream = this;
        synchronized (messageOutputStream) {
            this.callback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySuccess() {
        Callback callback;
        MessageOutputStream messageOutputStream = this;
        synchronized (messageOutputStream) {
            callback = this.callback;
        }
        if (callback != null) {
            callback.succeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFailure(Throwable failure) {
        Callback callback;
        MessageOutputStream messageOutputStream = this;
        synchronized (messageOutputStream) {
            callback = this.callback;
        }
        if (callback != null) {
            callback.failed(failure);
        }
    }
}

