/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.MultiPartFormInputStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;

public interface MultiParts
extends Closeable {
    public Collection<Part> getParts() throws IOException;

    public Part getPart(String var1) throws IOException;

    public boolean isEmpty();

    public ContextHandler.Context getContext();

    public static class MultiPartsHttpParser
    implements MultiParts {
        private final MultiPartFormInputStream _httpParser;
        private final ContextHandler.Context _context;

        public MultiPartsHttpParser(InputStream in, String contentType, MultipartConfigElement config, File contextTmpDir, Request request) throws IOException {
            this._httpParser = new MultiPartFormInputStream(in, contentType, config, contextTmpDir);
            this._context = request.getContext();
        }

        @Override
        public Collection<Part> getParts() throws IOException {
            return this._httpParser.getParts();
        }

        @Override
        public Part getPart(String name) throws IOException {
            return this._httpParser.getPart(name);
        }

        @Override
        public void close() {
            this._httpParser.deleteParts();
        }

        @Override
        public boolean isEmpty() {
            return this._httpParser.isEmpty();
        }

        @Override
        public ContextHandler.Context getContext() {
            return this._context;
        }
    }
}

